/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal;

import com.android.ddmlib.Log;
import com.android.ddmlib.internal.commands.CommandResult;
import com.android.ddmlib.internal.commands.ICommand;
import java.io.EOFException;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class CommandService
implements Runnable {
    private ServerSocketChannel listenChannel = null;
    private InetSocketAddress serverAddress = null;
    private boolean quit = true;
    private Thread runThread = null;
    private Timer startTimer = null;
    private final Map<String, ICommand> commandMap = new HashMap<String, ICommand>();
    private static final Long JOIN_TIMEOUT_MS = 5000L;
    private static final Long RETRY_SERVER_MILLIS = 301000L;
    private final Integer mListenPort;

    public Integer getBoundPort() {
        if (this.listenChannel == null || this.listenChannel.socket() == null) {
            return -1;
        }
        return this.listenChannel.socket().getLocalPort();
    }

    public CommandService(Integer mListenPort) {
        this.mListenPort = mListenPort;
    }

    public void addCommand(String command, ICommand handler) {
        this.commandMap.put(command, handler);
    }

    public void stop() {
        this.quit = true;
        if (this.listenChannel != null) {
            try {
                this.listenChannel.close();
                this.listenChannel.socket().close();
            }
            catch (IOException ex) {
                Log.w("CommandService", ex);
            }
        }
        if (this.runThread != null) {
            try {
                this.runThread.join(JOIN_TIMEOUT_MS);
                if (this.runThread.isAlive()) {
                    Log.e("CommandService", "Run thread still alive after " + JOIN_TIMEOUT_MS + "ms");
                }
            }
            catch (InterruptedException ex) {
                Log.w("CommandService", ex);
            }
        }
        this.listenChannel = null;
        this.runThread = null;
    }

    public void start() {
        if (this.startTimer == null) {
            this.startTimer = new Timer("CommandServiceTimer");
            this.startTimer.schedule((TimerTask)new ServerHostTimer(), 0L, (long)RETRY_SERVER_MILLIS);
        }
    }

    @Override
    public void run() {
        while (!this.quit) {
            try {
                if (this.listenChannel == null) continue;
                SocketChannel client = this.listenChannel.accept();
                try {
                    if (client == null) continue;
                    this.processOneCommand(client);
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
            catch (IOException ex) {
                Log.e("CommandService", ex);
                return;
            }
        }
    }

    private void processOneCommand(SocketChannel client) throws IOException {
        ByteBuffer buffer2 = this.readExactly(client, 4);
        Integer cmdSize = Integer.parseInt(StandardCharsets.UTF_8.decode(buffer2).toString(), 16);
        String data = StandardCharsets.UTF_8.decode(buffer2 = this.readExactly(client, cmdSize)).toString();
        int commandTerminator = data.indexOf(":");
        if (commandTerminator == -1 && this.commandMap.containsKey(data)) {
            this.write(this.commandMap.get(data).run(null), client);
        } else if (commandTerminator != -1) {
            String command = data.substring(0, commandTerminator);
            String argsString = data.substring(commandTerminator + 1);
            if (!this.commandMap.containsKey(command)) {
                Log.w("CommandService", "Unknown command received");
                return;
            }
            try {
                this.write(this.commandMap.get(command).run(argsString), client);
            }
            catch (Throwable t) {
                Log.w("CommandService", t);
            }
        } else {
            Log.w("CommandService", "Failed to find command");
        }
    }

    private ByteBuffer readExactly(SocketChannel client, Integer amount) throws IOException {
        ByteBuffer buffer2 = ByteBuffer.allocate(amount);
        while (buffer2.hasRemaining()) {
            int count = client.read(buffer2);
            if (count != -1) continue;
            throw new EOFException("Unexpected end of channel");
        }
        buffer2.position(0);
        return buffer2;
    }

    private void write(CommandResult result, SocketChannel client) throws IOException {
        if (result.getSuccess()) {
            client.write(this.wrapString("OKAY"));
        } else {
            client.write(this.wrapString(String.format("FAIL%04x%s", result.getMessage().length(), result.getMessage())));
        }
    }

    private ByteBuffer wrapString(String str) {
        return ByteBuffer.wrap(str.getBytes(StandardCharsets.UTF_8));
    }

    private class ServerHostTimer
    extends TimerTask {
        private ServerHostTimer() {
        }

        @Override
        public void run() {
            try {
                CommandService.this.serverAddress = new InetSocketAddress(InetAddress.getByName("localhost"), (int)CommandService.this.mListenPort);
                CommandService.this.listenChannel = ServerSocketChannel.open();
                CommandService.this.listenChannel.socket().setReuseAddress(true);
                CommandService.this.listenChannel.socket().bind(CommandService.this.serverAddress);
            }
            catch (BindException ex) {
                Log.i("CommandService", "Port is already bound");
                return;
            }
            catch (IOException ex) {
                Log.e("CommandService", ex);
                return;
            }
            CommandService.this.quit = false;
            CommandService.this.runThread = new Thread((Runnable)CommandService.this, "CommandServiceConnection");
            CommandService.this.runThread.start();
            CommandService.this.startTimer.cancel();
            CommandService.this.startTimer = null;
        }
    }
}

