/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class RawImage {
    public int version;
    public int bpp;
    public int colorSpace;
    public int size;
    public int width;
    public int height;
    public int red_offset;
    public int red_length;
    public int blue_offset;
    public int blue_length;
    public int green_offset;
    public int green_length;
    public int alpha_offset;
    public int alpha_length;
    public byte[] data;
    public static final int COLOR_SPACE_UNKNOWN = 0;
    public static final int COLOR_SPACE_SRGB = 1;
    public static final int COLOR_SPACE_DISPLAY_P3 = 2;

    public boolean readHeader(int version2, ByteBuffer buf) {
        this.version = version2;
        if (version2 == 16) {
            this.bpp = 16;
            this.size = buf.getInt();
            this.width = buf.getInt();
            this.height = buf.getInt();
            this.red_offset = 11;
            this.red_length = 5;
            this.green_offset = 5;
            this.green_length = 6;
            this.blue_offset = 0;
            this.blue_length = 5;
            this.alpha_offset = 0;
            this.alpha_length = 0;
        } else if (version2 == 1 || version2 == 2) {
            this.bpp = buf.getInt();
            if (version2 == 2) {
                this.colorSpace = buf.getInt();
            }
            this.size = buf.getInt();
            this.width = buf.getInt();
            this.height = buf.getInt();
            this.red_offset = buf.getInt();
            this.red_length = buf.getInt();
            this.blue_offset = buf.getInt();
            this.blue_length = buf.getInt();
            this.green_offset = buf.getInt();
            this.green_length = buf.getInt();
            this.alpha_offset = buf.getInt();
            this.alpha_length = buf.getInt();
        } else {
            return false;
        }
        return true;
    }

    public int getRedMask() {
        return this.getMask(this.red_length, this.red_offset);
    }

    public int getGreenMask() {
        return this.getMask(this.green_length, this.green_offset);
    }

    public int getBlueMask() {
        return this.getMask(this.blue_length, this.blue_offset);
    }

    public static int getHeaderSize(int version2) {
        switch (version2) {
            case 16: {
                return 3;
            }
            case 1: {
                return 12;
            }
            case 2: {
                return 13;
            }
        }
        return 0;
    }

    public RawImage getRotated() {
        RawImage rotated = new RawImage();
        rotated.version = this.version;
        rotated.bpp = this.bpp;
        rotated.colorSpace = this.colorSpace;
        rotated.size = this.size;
        rotated.red_offset = this.red_offset;
        rotated.red_length = this.red_length;
        rotated.blue_offset = this.blue_offset;
        rotated.blue_length = this.blue_length;
        rotated.green_offset = this.green_offset;
        rotated.green_length = this.green_length;
        rotated.alpha_offset = this.alpha_offset;
        rotated.alpha_length = this.alpha_length;
        rotated.width = this.height;
        rotated.height = this.width;
        int count = this.data.length;
        rotated.data = new byte[count];
        int byteCount = this.bpp >> 3;
        int w = this.width;
        int h = this.height;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                System.arraycopy(this.data, (y * w + x) * byteCount, rotated.data, ((w - x - 1) * h + y) * byteCount, byteCount);
            }
        }
        return rotated;
    }

    public int getARGB(int index2) {
        int a;
        int b;
        int g;
        int r;
        if (this.bpp == 16) {
            int value = this.data[index2] & 0xFF;
            r = ((value |= this.data[index2 + 1] << 8 & 0xFF00) >>> 11 & 0x1F) * 255 / 31;
            g = (value >>> 5 & 0x3F) * 255 / 63;
            b = (value & 0x1F) * 255 / 31;
            a = 255;
        } else if (this.bpp == 32) {
            int value = this.data[index2] & 0xFF;
            value |= (this.data[index2 + 1] & 0xFF) << 8;
            value |= (this.data[index2 + 2] & 0xFF) << 16;
            r = ((value |= (this.data[index2 + 3] & 0xFF) << 24) >>> this.red_offset & RawImage.getMask(this.red_length)) << 8 - this.red_length;
            g = (value >>> this.green_offset & RawImage.getMask(this.green_length)) << 8 - this.green_length;
            b = (value >>> this.blue_offset & RawImage.getMask(this.blue_length)) << 8 - this.blue_length;
            a = (value >>> this.alpha_offset & RawImage.getMask(this.alpha_length)) << 8 - this.alpha_length;
        } else {
            throw new UnsupportedOperationException("RawImage.getARGB(int) only works in 16 and 32 bit mode.");
        }
        return a << 24 | r << 16 | g << 8 | b;
    }

    public BufferedImage asBufferedImage() {
        BufferedImage image;
        String profileName = this.getProfileName();
        if (profileName == null) {
            image = new BufferedImage(this.width, this.height, 2);
        } else {
            ICC_Profile profile = ICC_Profile.getInstance(1000);
            try {
                profile = ICC_Profile.getInstance(this.getClass().getClassLoader().getResourceAsStream("colorProfiles/" + profileName));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ICC_ColorSpace colorSpace = new ICC_ColorSpace(profile);
            DirectColorModel colorModel = new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, false, 3);
            WritableRaster raster = ((ColorModel)colorModel).createCompatibleWritableRaster(this.width, this.height);
            image = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
        }
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int argb = this.getARGB((x + y * this.width) * (this.bpp / 8));
                image.setRGB(x, y, argb);
            }
        }
        return image;
    }

    public String getProfileName() {
        switch (this.colorSpace) {
            case 0: {
                return null;
            }
            case 1: {
                return "sRGB.icc";
            }
            case 2: {
                return "DisplayP3.icc";
            }
        }
        return null;
    }

    private int getMask(int length, int offset) {
        int res = RawImage.getMask(length) << offset;
        if (this.bpp == 32) {
            return Integer.reverseBytes(res);
        }
        return res;
    }

    private static int getMask(int length) {
        return (1 << length) - 1;
    }
}

