/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.DdmPreferences;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;

public final class Log {
    private static LogLevel sLevel = DdmPreferences.getLogLevel();
    private static ILogOutput sLogOutput;
    private static final Set<ILogOutput> sOutputLoggers;
    private static final SimpleDateFormat sLogFormatter;
    private static final char[] mSpaceLine;
    private static final char[] mHexDigit;

    private Log() {
    }

    public static void v(String tag, String message2) {
        Log.println(LogLevel.VERBOSE, tag, message2);
    }

    public static void d(String tag, String message2) {
        Log.println(LogLevel.DEBUG, tag, message2);
    }

    public static void i(String tag, String message2) {
        Log.println(LogLevel.INFO, tag, message2);
    }

    public static void w(String tag, String message2) {
        Log.println(LogLevel.WARN, tag, message2);
    }

    public static void e(String tag, String message2) {
        Log.println(LogLevel.ERROR, tag, message2);
    }

    public static void logAndDisplay(LogLevel logLevel, String tag, String message2) {
        if (!sOutputLoggers.isEmpty()) {
            for (ILogOutput logger : sOutputLoggers) {
                logger.printAndPromptLog(logLevel, tag, message2);
            }
        }
        if (sLogOutput != null) {
            sLogOutput.printAndPromptLog(logLevel, tag, message2);
        } else if (sOutputLoggers.isEmpty()) {
            Log.println(logLevel, tag, message2);
        }
    }

    public static void v(String tag, Throwable throwable) {
        Log.logThrowable(LogLevel.VERBOSE, tag, throwable);
    }

    public static void d(String tag, Throwable throwable) {
        Log.logThrowable(LogLevel.DEBUG, tag, throwable);
    }

    public static void i(String tag, Throwable throwable) {
        Log.logThrowable(LogLevel.INFO, tag, throwable);
    }

    public static void w(String tag, Throwable throwable) {
        Log.logThrowable(LogLevel.WARN, tag, throwable);
    }

    public static void e(String tag, Throwable throwable) {
        Log.logThrowable(LogLevel.ERROR, tag, throwable);
    }

    private static void logThrowable(LogLevel level, String tag, Throwable throwable) {
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            Log.println(level, tag, throwable.getMessage() + '\n' + sw.toString());
        }
    }

    @VisibleForTesting
    public static void setLevel(LogLevel logLevel) {
        sLevel = logLevel;
    }

    public static boolean isAtLeast(LogLevel logLevel) {
        return logLevel.getPriority() >= sLevel.getPriority();
    }

    @Deprecated
    public static void setLogOutput(ILogOutput logOutput) {
        sLogOutput = logOutput;
    }

    public static void addLogger(ILogOutput logOutput) {
        sOutputLoggers.add(logOutput);
    }

    public static void removeLogger(ILogOutput logOutput) {
        sOutputLoggers.remove(logOutput);
    }

    public static void hexDump(String tag, LogLevel level, byte[] data, int offset, int length) {
    }

    static void hexDump(byte[] data) {
        Log.hexDump("ddms", LogLevel.DEBUG, data, 0, data.length);
    }

    public static void println(LogLevel logLevel, String tag, String message2) {
        if (!Log.isAtLeast(logLevel)) {
            return;
        }
        if (!sOutputLoggers.isEmpty()) {
            for (ILogOutput logger : sOutputLoggers) {
                logger.printLog(logLevel, tag, message2);
            }
        }
        if (sLogOutput != null) {
            sLogOutput.printLog(logLevel, tag, message2);
        } else if (sOutputLoggers.isEmpty()) {
            Log.printLog(logLevel, tag, message2);
        }
    }

    public static void printLog(LogLevel logLevel, String tag, String message2) {
        System.out.print(Log.getLogFormatString(logLevel, tag, message2));
    }

    public static String getLogFormatString(LogLevel logLevel, String tag, String message2) {
        return String.format("%s %c/%s: %s\n", sLogFormatter.format(new Date()), Character.valueOf(logLevel.getPriorityLetter()), tag, message2);
    }

    static {
        sOutputLoggers = Sets.newCopyOnWriteArraySet();
        sLogFormatter = new SimpleDateFormat("hh:mm:ss", Locale.US);
        mSpaceLine = new char[72];
        mHexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int i = mSpaceLine.length - 1;
        while (i >= 0) {
            Log.mSpaceLine[i--] = 32;
        }
        Log.mSpaceLine[3] = 48;
        Log.mSpaceLine[2] = 48;
        Log.mSpaceLine[1] = 48;
        Log.mSpaceLine[0] = 48;
        Log.mSpaceLine[4] = 45;
    }

    public static final class Config {
        public static final boolean LOGV = true;
        public static final boolean LOGD = true;
        public static final boolean HEX_DUMP = false;
    }

    public static interface ILogOutput {
        public void printLog(LogLevel var1, String var2, String var3);

        public void printAndPromptLog(LogLevel var1, String var2, String var3);
    }

    public static enum LogLevel {
        VERBOSE(2, "verbose", 'V'),
        DEBUG(3, "debug", 'D'),
        INFO(4, "info", 'I'),
        WARN(5, "warn", 'W'),
        ERROR(6, "error", 'E'),
        ASSERT(7, "assert", 'A');

        private int mPriorityLevel;
        private String mStringValue;
        private char mPriorityLetter;

        private LogLevel(int intPriority, String stringValue, char priorityChar) {
            this.mPriorityLevel = intPriority;
            this.mStringValue = stringValue;
            this.mPriorityLetter = priorityChar;
        }

        public static LogLevel getByString(String value) {
            for (LogLevel mode : LogLevel.values()) {
                if (!mode.mStringValue.equals(value)) continue;
                return mode;
            }
            return null;
        }

        public static LogLevel getByLetter(char letter) {
            for (LogLevel mode : LogLevel.values()) {
                if (mode.mPriorityLetter != letter) continue;
                return mode;
            }
            return null;
        }

        public static LogLevel getByLetterString(String letter) {
            if (!letter.isEmpty()) {
                return LogLevel.getByLetter(letter.charAt(0));
            }
            return null;
        }

        public char getPriorityLetter() {
            return this.mPriorityLetter;
        }

        public int getPriority() {
            return this.mPriorityLevel;
        }

        public String getStringValue() {
            return this.mStringValue;
        }
    }
}

