/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.google.common.collect.ImmutableMap;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Map;

public class BitmapDecoder {
    public static final String BITMAP_FQCN = "android.graphics.Bitmap";
    public static final String BITMAP_DRAWABLE_FQCN = "android.graphics.drawable.BitmapDrawable";
    protected static final Map<String, BitmapExtractor> SUPPORTED_FORMATS = ImmutableMap.of((Object)"\"ARGB_8888\"", (Object)new ARGB8888_BitmapExtractor(), (Object)"\"RGB_565\"", (Object)new RGB565_BitmapExtractor(), (Object)"\"ALPHA_8\"", (Object)new ALPHA8_BitmapExtractor());
    private static final int MAX_DIMENSION = 1024;

    public static BufferedImage getBitmap(BitmapDataProvider dataProvider) throws Exception {
        String config = dataProvider.getBitmapConfigName();
        if (config == null) {
            throw new RuntimeException("Unable to determine bitmap configuration");
        }
        BitmapExtractor bitmapExtractor = SUPPORTED_FORMATS.get(config);
        if (bitmapExtractor == null) {
            throw new RuntimeException("Unsupported bitmap configuration: " + config);
        }
        Dimension size = dataProvider.getDimension();
        if (size == null) {
            throw new RuntimeException("Unable to determine image dimensions.");
        }
        if (size.width > 1024 || size.height > 1024) {
            boolean couldDownsize = dataProvider.downsizeBitmap(size);
            if (!couldDownsize) {
                throw new RuntimeException("Unable to create scaled bitmap");
            }
            size = dataProvider.getDimension();
            if (size == null) {
                throw new RuntimeException("Unable to obtained scaled bitmap's dimensions");
            }
        }
        return bitmapExtractor.getImage(size.width, size.height, dataProvider.getPixelBytes(size));
    }

    private static class ALPHA8_BitmapExtractor
    implements BitmapExtractor {
        private ALPHA8_BitmapExtractor() {
        }

        @Override
        public BufferedImage getImage(int width, int height, byte[] rgb) {
            boolean bytesPerPixel = true;
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            for (int y = 0; y < height; ++y) {
                int stride = y * width;
                for (int x = 0; x < width; ++x) {
                    int index2 = stride + x;
                    byte value = rgb[index2];
                    int rgba = value << 24 | 0xFF0000 | 0xFF00 | 0xFF;
                    bufferedImage.setRGB(x, y, rgba);
                }
            }
            return bufferedImage;
        }
    }

    private static class RGB565_BitmapExtractor
    implements BitmapExtractor {
        private RGB565_BitmapExtractor() {
        }

        @Override
        public BufferedImage getImage(int width, int height, byte[] rgb) {
            int bytesPerPixel = 2;
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            for (int y = 0; y < height; ++y) {
                int stride = y * width;
                for (int x = 0; x < width; ++x) {
                    int index2 = (stride + x) * bytesPerPixel;
                    int value = rgb[index2] & 0xFF | rgb[index2 + 1] << 8 & 0xFF00;
                    int r = (value >>> 11 & 0x1F) * 255 / 31;
                    int g = (value >>> 5 & 0x3F) * 255 / 63;
                    int b = (value & 0x1F) * 255 / 31;
                    int a = 255;
                    int rgba = a << 24 | r << 16 | g << 8 | b;
                    bufferedImage.setRGB(x, y, rgba);
                }
            }
            return bufferedImage;
        }
    }

    private static class ARGB8888_BitmapExtractor
    implements BitmapExtractor {
        private ARGB8888_BitmapExtractor() {
        }

        @Override
        public BufferedImage getImage(int width, int height, byte[] rgba) {
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            for (int y = 0; y < height; ++y) {
                int stride = y * width;
                for (int x = 0; x < width; ++x) {
                    int i = (stride + x) * 4;
                    long rgb = 0L;
                    rgb |= ((long)rgba[i] & 0xFFL) << 16;
                    rgb |= ((long)rgba[i + 1] & 0xFFL) << 8;
                    rgb |= (long)rgba[i + 2] & 0xFFL;
                    bufferedImage.setRGB(x, y, (int)((rgb |= ((long)rgba[i + 3] & 0xFFL) << 24) & 0xFFFFFFFFL));
                }
            }
            return bufferedImage;
        }
    }

    private static interface BitmapExtractor {
        public BufferedImage getImage(int var1, int var2, byte[] var3);
    }

    public static interface BitmapDataProvider {
        public String getBitmapConfigName() throws Exception;

        public Dimension getDimension() throws Exception;

        public boolean downsizeBitmap(Dimension var1) throws Exception;

        public byte[] getPixelBytes(Dimension var1) throws Exception;
    }
}

