/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl.channels;

import com.android.adblib.AdbLogger;
import com.android.adblib.AdbLoggerFactory;
import com.android.adblib.AdbSessionHost;
import com.android.adblib.impl.TimeoutTracker;
import com.android.adblib.impl.channels.AdbSocketChannelImplKt;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0003\b \u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J\u0011\u0010\u001c\u001a\u00020\u0002H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0016J\u0016\u0010!\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0002J\u001e\u0010\"\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003H$R\u0012\u0010\u000b\u001a\u00020\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Lcom/android/adblib/impl/channels/AsynchronousChannelWriteOperation;", "Ljava/nio/channels/CompletionHandler;", "", "Lkotlinx/coroutines/CancellableContinuation;", "host", "Lcom/android/adblib/AdbSessionHost;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(Lcom/android/adblib/AdbSessionHost;JLjava/util/concurrent/TimeUnit;)V", "channel", "Ljava/nio/channels/Channel;", "getChannel", "()Ljava/nio/channels/Channel;", "hasRemaining", "", "getHasRemaining", "()Z", "getHost", "()Lcom/android/adblib/AdbSessionHost;", "logger", "Lcom/android/adblib/AdbLogger;", "Lcom/android/adblib/impl/TimeoutTracker;", "completed", "", "result", "continuation", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "failed", "exc", "", "writeAsync", "writeChannel", "android.sdktools.adblib"})
public abstract class AsynchronousChannelWriteOperation
implements CompletionHandler<Integer, CancellableContinuation<? super Integer>> {
    @NotNull
    private final AdbSessionHost host;
    @NotNull
    private final AdbLogger logger;
    @NotNull
    private final TimeoutTracker timeout;

    /*
     * WARNING - void declaration
     */
    public AsynchronousChannelWriteOperation(@NotNull AdbSessionHost host, long timeout, @NotNull TimeUnit unit) {
        void $this$thisLogger$iv;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.host = host;
        AsynchronousChannelWriteOperation asynchronousChannelWriteOperation = this;
        AdbSessionHost host$iv = this.host;
        boolean $i$f$thisLogger = false;
        void var8_7 = $this$thisLogger$iv;
        AdbLoggerFactory loggerFactory$iv$iv = host$iv.getLoggerFactory();
        boolean $i$f$thisLogger2 = false;
        this.logger = loggerFactory$iv$iv.createLogger(AsynchronousChannelWriteOperation.class);
        this.timeout = new TimeoutTracker(this.host.getTimeProvider(), timeout, unit);
    }

    @NotNull
    protected final AdbSessionHost getHost() {
        return this.host;
    }

    protected abstract boolean getHasRemaining();

    @NotNull
    protected abstract Channel getChannel();

    protected abstract void writeChannel(@NotNull TimeoutTracker var1, @NotNull CancellableContinuation<? super Integer> var2);

    @Nullable
    public final Object execute(@NotNull Continuation<? super Integer> $completion) {
        if (!this.getHasRemaining()) {
            return Boxing.boxInt((int)0);
        }
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Integer> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        AdbSocketChannelImplKt.closeOnCancel(this.getChannel(), this.getHost(), "write", continuation);
        this.writeAsync((CancellableContinuation<? super Integer>)continuation);
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final void writeAsync(CancellableContinuation<? super Integer> continuation) {
        try {
            this.timeout.throwIfElapsed();
            this.writeChannel(this.timeout, continuation);
        }
        catch (Throwable t) {
            ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t)));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void completed(int result, @NotNull CancellableContinuation<? super Integer> continuation) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        AdbLogger this_$iv = this.logger;
        boolean $i$f$verbose = false;
        AdbLogger adbLogger = this_$iv;
        AdbLogger.Level level$iv$iv = AdbLogger.Level.VERBOSE;
        boolean $i$f$logIf = false;
        if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
            AdbLogger.Level level = level$iv$iv;
            void var9_10 = this_$iv$iv;
            boolean bl = false;
            String string = "writeAsync completed successfully (" + result + " bytes)";
            var9_10.log(level, string);
        }
        Integer n = result;
        ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)n));
    }

    @Override
    public void failed(@NotNull Throwable exc, @NotNull CancellableContinuation<? super Integer> continuation) {
        Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        IOException error = new IOException("Error writing data to asynchronous channel", exc);
        ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)error)));
    }
}

