/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl.channels;

import com.android.adblib.AdbLogger;
import com.android.adblib.AdbLoggerFactory;
import com.android.adblib.AdbSessionHost;
import com.android.adblib.impl.TimeoutTracker;
import com.android.adblib.impl.channels.AdbSocketChannelImplKt;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0003\b \u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u0011\u0010\u001c\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u0016\u0010!\u001a\u00020\u00042\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u001e\u0010\"\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H$R\u0012\u0010\f\u001a\u00020\rX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Lcom/android/adblib/impl/channels/AsynchronousChannelWriteExactlyOperation;", "Ljava/nio/channels/CompletionHandler;", "", "Lkotlinx/coroutines/CancellableContinuation;", "", "host", "Lcom/android/adblib/AdbSessionHost;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(Lcom/android/adblib/AdbSessionHost;JLjava/util/concurrent/TimeUnit;)V", "channel", "Ljava/nio/channels/Channel;", "getChannel", "()Ljava/nio/channels/Channel;", "hasRemaining", "", "getHasRemaining", "()Z", "getHost", "()Lcom/android/adblib/AdbSessionHost;", "logger", "Lcom/android/adblib/AdbLogger;", "Lcom/android/adblib/impl/TimeoutTracker;", "completed", "result", "continuation", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "failed", "exc", "", "writeAsync", "writeChannel", "android.sdktools.adblib"})
public abstract class AsynchronousChannelWriteExactlyOperation
implements CompletionHandler<Integer, CancellableContinuation<? super Unit>> {
    @NotNull
    private final AdbSessionHost host;
    @NotNull
    private final AdbLogger logger;
    @NotNull
    private final TimeoutTracker timeout;

    /*
     * WARNING - void declaration
     */
    public AsynchronousChannelWriteExactlyOperation(@NotNull AdbSessionHost host, long timeout, @NotNull TimeUnit unit) {
        void $this$thisLogger$iv;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.host = host;
        AsynchronousChannelWriteExactlyOperation asynchronousChannelWriteExactlyOperation = this;
        AdbSessionHost host$iv = this.host;
        boolean $i$f$thisLogger = false;
        void var8_7 = $this$thisLogger$iv;
        AdbLoggerFactory loggerFactory$iv$iv = host$iv.getLoggerFactory();
        boolean $i$f$thisLogger2 = false;
        this.logger = loggerFactory$iv$iv.createLogger(AsynchronousChannelWriteExactlyOperation.class);
        this.timeout = new TimeoutTracker(this.host.getTimeProvider(), timeout, unit);
    }

    @NotNull
    protected final AdbSessionHost getHost() {
        return this.host;
    }

    protected abstract boolean getHasRemaining();

    @NotNull
    protected abstract Channel getChannel();

    protected abstract void writeChannel(@NotNull TimeoutTracker var1, @NotNull CancellableContinuation<? super Unit> var2);

    @Nullable
    public final Object execute(@NotNull Continuation<? super Unit> $completion) {
        if (!this.getHasRemaining()) {
            return Unit.INSTANCE;
        }
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        AdbSocketChannelImplKt.closeOnCancel(this.getChannel(), this.getHost(), "writeExactly", continuation);
        this.writeAsync((CancellableContinuation<? super Unit>)continuation);
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void writeAsync(CancellableContinuation<? super Unit> continuation) {
        try {
            this.timeout.throwIfElapsed();
            this.writeChannel(this.timeout, continuation);
        }
        catch (Throwable t) {
            ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t)));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void completed(int result, @NotNull CancellableContinuation<? super Unit> continuation) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        AdbLogger this_$iv = this.logger;
        boolean $i$f$debug = false;
        AdbLogger adbLogger = this_$iv;
        AdbLogger.Level level$iv$iv = AdbLogger.Level.DEBUG;
        boolean $i$f$logIf = false;
        if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
            AdbLogger.Level level = level$iv$iv;
            void var9_9 = this_$iv$iv;
            boolean bl = false;
            String string = "writeAsync completed successfully (" + result + " bytes)";
            var9_9.log(level, string);
        }
        if (!this.getHasRemaining()) {
            ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
            return;
        }
        this.writeAsync(continuation);
    }

    @Override
    public void failed(@NotNull Throwable exc, @NotNull CancellableContinuation<? super Unit> continuation) {
        Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        IOException error = new IOException("Error writing data to asynchronous channel", exc);
        ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)error)));
    }
}

