/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"INFINITE_TIMEOUT", "", "remainingTimeoutToString", "", "timeout", "unit", "Ljava/util/concurrent/TimeUnit;", "android.sdktools.adblib"})
public final class TimeoutTrackerKt {
    private static final long INFINITE_TIMEOUT = Long.MAX_VALUE;

    @NotNull
    public static final String remainingTimeoutToString(long timeout, @NotNull TimeUnit unit) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (timeout == Long.MAX_VALUE) {
            String string2 = "<INFINITE> msec remaining";
            Object[] objectArray = new Object[]{};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        } else {
            String string4 = "%,.1f msec remaining";
            Object[] objectArray = new Object[]{(double)TimeUnit.MILLISECONDS.convert(timeout, unit)};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
        }
        return string;
    }
}

