/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H&J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0004H&\u00a8\u0006\t"}, d2={"Lcom/android/adblib/impl/StdoutByteBufferProcessor;", "", "()V", "convertBuffer", "Ljava/nio/ByteBuffer;", "buffer", "convertBufferEnd", "DirectProcessor", "StripCrLfProcessor", "android.sdktools.adblib"})
public abstract class StdoutByteBufferProcessor {
    @NotNull
    public abstract ByteBuffer convertBuffer(@NotNull ByteBuffer var1);

    @Nullable
    public abstract ByteBuffer convertBufferEnd();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/adblib/impl/StdoutByteBufferProcessor$DirectProcessor;", "Lcom/android/adblib/impl/StdoutByteBufferProcessor;", "()V", "convertBuffer", "Ljava/nio/ByteBuffer;", "buffer", "convertBufferEnd", "android.sdktools.adblib"})
    public static final class DirectProcessor
    extends StdoutByteBufferProcessor {
        @Override
        @NotNull
        public ByteBuffer convertBuffer(@NotNull ByteBuffer buffer2) {
            Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer");
            return buffer2;
        }

        @Override
        @Nullable
        public ByteBuffer convertBufferEnd() {
            return null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0002J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u00072\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u0014H\u0002R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/adblib/impl/StdoutByteBufferProcessor$StripCrLfProcessor;", "Lcom/android/adblib/impl/StdoutByteBufferProcessor;", "()V", "leftoverByte", "", "Ljava/lang/Byte;", "workBuffer", "Ljava/nio/ByteBuffer;", "convertBuffer", "buffer", "convertBufferEnd", "ensureWorkBuffer", "indexOfCrLf", "", "bytes", "offset", "limit", "processCrLfRanges", "", "block", "Lkotlin/Function2;", "android.sdktools.adblib"})
    public static final class StripCrLfProcessor
    extends StdoutByteBufferProcessor {
        @Nullable
        private ByteBuffer workBuffer;
        @Nullable
        private Byte leftoverByte;

        @Override
        @NotNull
        public ByteBuffer convertBuffer(@NotNull ByteBuffer buffer2) {
            Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer");
            if (buffer2.remaining() == 0) {
                return buffer2;
            }
            ByteBuffer destinationBuffer = this.ensureWorkBuffer(buffer2);
            destinationBuffer.clear();
            Byte by = this.leftoverByte;
            if (by != null) {
                boolean bl;
                byte by2 = ((Number)by).byteValue();
                boolean bl2 = false;
                boolean bl3 = bl = buffer2.remaining() > 0;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                if (by2 != (byte)13 || buffer2.get(buffer2.position()) != (byte)10) {
                    destinationBuffer.put(by2);
                }
                this.leftoverByte = null;
            }
            ByteBuffer slice = buffer2.slice();
            this.processCrLfRanges(buffer2, (Function2<? super Integer, ? super Integer, Unit>)((Function2)new Function2<Integer, Integer, Unit>(buffer2, this, destinationBuffer, slice){
                final /* synthetic */ ByteBuffer $buffer;
                final /* synthetic */ StripCrLfProcessor this$0;
                final /* synthetic */ ByteBuffer $destinationBuffer;
                final /* synthetic */ ByteBuffer $slice;
                {
                    this.$buffer = $buffer;
                    this.this$0 = $receiver;
                    this.$destinationBuffer = $destinationBuffer;
                    this.$slice = $slice;
                    super(2);
                }

                public final void invoke(int start2, int end2) {
                    int n;
                    if (end2 == this.$buffer.limit() && start2 < end2 && this.$buffer.get(end2 - 1) == (byte)13) {
                        StripCrLfProcessor.access$setLeftoverByte$p(this.this$0, (byte)13);
                        n = end2 - 1;
                    } else if (end2 == this.$buffer.limit() && this.$destinationBuffer.remaining() < end2 - start2) {
                        boolean bl;
                        boolean bl2 = bl = this.$destinationBuffer.remaining() == end2 - start2 - 1;
                        if (_Assertions.ENABLED && !bl) {
                            String string = "Assertion failed";
                            throw new AssertionError((Object)string);
                        }
                        StripCrLfProcessor.access$setLeftoverByte$p(this.this$0, this.$buffer.get(end2 - 1));
                        n = end2 - 1;
                    } else {
                        n = end2;
                    }
                    int actualEnd = n;
                    this.$slice.limit(actualEnd);
                    this.$slice.position(start2);
                    this.$destinationBuffer.put(this.$slice);
                }
            }));
            buffer2.position(buffer2.limit());
            destinationBuffer.flip();
            return destinationBuffer;
        }

        @Override
        @Nullable
        public ByteBuffer convertBufferEnd() {
            ByteBuffer byteBuffer;
            Byte by = this.leftoverByte;
            if (by != null) {
                byte by2 = ((Number)by).byteValue();
                boolean bl = false;
                ByteBuffer byteBuffer2 = this.workBuffer;
                if (byteBuffer2 != null) {
                    ByteBuffer buffer2 = byteBuffer2;
                    boolean bl2 = false;
                    buffer2.clear();
                    buffer2.put(by2);
                    buffer2.flip();
                }
                byteBuffer = this.workBuffer;
            } else {
                byteBuffer = null;
            }
            return byteBuffer;
        }

        private final ByteBuffer ensureWorkBuffer(ByteBuffer buffer2) {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = this.workBuffer;
            if (byteBuffer2 != null) {
                ByteBuffer byteBuffer3;
                ByteBuffer it = byteBuffer3 = byteBuffer2;
                boolean bl = false;
                if (it.capacity() != buffer2.capacity()) {
                    throw new IllegalArgumentException("ByteBuffer capacity should not vary during successive calls");
                }
                byteBuffer = byteBuffer3;
            } else {
                ByteBuffer byteBuffer4;
                ByteBuffer it = byteBuffer4 = ByteBuffer.allocate(buffer2.capacity());
                boolean bl = false;
                this.workBuffer = it;
                ByteBuffer byteBuffer5 = byteBuffer4;
                byteBuffer = byteBuffer5;
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer5, (String)"allocate(buffer.capacity\u2026.also { workBuffer = it }");
            }
            return byteBuffer;
        }

        private final void processCrLfRanges(ByteBuffer buffer2, Function2<? super Integer, ? super Integer, Unit> block) {
            int index2 = buffer2.position();
            int limit = buffer2.limit();
            while (index2 < limit) {
                int crLfOffset = this.indexOfCrLf(buffer2, index2, limit);
                if (crLfOffset < 0) {
                    block.invoke((Object)index2, (Object)limit);
                    break;
                }
                block.invoke((Object)index2, (Object)crLfOffset);
                index2 = crLfOffset + 1;
            }
        }

        private final int indexOfCrLf(ByteBuffer bytes, int offset, int limit) {
            byte previousByte = -1;
            for (int index2 = offset; index2 < limit; ++index2) {
                byte currentByte = bytes.get(index2);
                if (previousByte == (byte)13 && currentByte == (byte)10) {
                    return index2 - 1;
                }
                previousByte = currentByte;
            }
            return -1;
        }

        public static final /* synthetic */ void access$setLeftoverByte$p(StripCrLfProcessor $this, Byte by) {
            $this.leftoverByte = by;
        }
    }
}

