/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import com.android.adblib.AdbHostServices;
import com.android.adblib.DeviceInfo;
import com.android.adblib.ListWithErrors;
import com.android.adblib.impl.DeviceListParserKt;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ&\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002J&\u0010\u0012\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002J\"\u0010\u0013\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/android/adblib/impl/DeviceListParser;", "", "()V", "parse", "Lcom/android/adblib/ListWithErrors;", "Lcom/android/adblib/DeviceInfo;", "Lcom/android/adblib/DeviceList;", "format", "Lcom/android/adblib/AdbHostServices$DeviceInfoFormat;", "responseText", "", "parseOneLongFormatLine", "", "result", "Lcom/android/adblib/ListWithErrors$Builder;", "lineIndex", "", "lineText", "parseOneShortFormatLine", "parserWorker", "oneLineParser", "Lcom/android/adblib/impl/DeviceListParser$OneLineParser;", "OneLineParser", "android.sdktools.adblib"})
public final class DeviceListParser {
    @NotNull
    public final ListWithErrors<DeviceInfo> parse(@NotNull AdbHostServices.DeviceInfoFormat format, @NotNull CharSequence responseText) {
        KFunction kFunction;
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter((Object)responseText, (String)"responseText");
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                kFunction = (KFunction)new Function3<ListWithErrors.Builder<DeviceInfo>, Integer, CharSequence, Unit>((Object)this){

                    public final void invoke(@NotNull ListWithErrors.Builder<DeviceInfo> p0, int p1, @NotNull CharSequence p2) {
                        Intrinsics.checkNotNullParameter(p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                        DeviceListParser.access$parseOneShortFormatLine((DeviceListParser)this.receiver, p0, p1, p2);
                    }
                };
                break;
            }
            case 2: {
                kFunction = (KFunction)new Function3<ListWithErrors.Builder<DeviceInfo>, Integer, CharSequence, Unit>((Object)this){

                    public final void invoke(@NotNull ListWithErrors.Builder<DeviceInfo> p0, int p1, @NotNull CharSequence p2) {
                        Intrinsics.checkNotNullParameter(p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                        DeviceListParser.access$parseOneLongFormatLine((DeviceListParser)this.receiver, p0, p1, p2);
                    }
                };
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        KFunction oneLineParser2 = kFunction;
        return this.parserWorker(responseText, new OneLineParser((Function3)oneLineParser2){
            private final /* synthetic */ Function3 function;
            {
                this.function = function;
            }

            public final /* synthetic */ void call(ListWithErrors.Builder result, int lineIndex, CharSequence lineText) {
                this.function.invoke((Object)result, (Object)lineIndex, (Object)lineText);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof OneLineParser ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    private final ListWithErrors<DeviceInfo> parserWorker(CharSequence responseText, OneLineParser oneLineParser2) {
        ListWithErrors.Builder<DeviceInfo> result = new ListWithErrors.Builder<DeviceInfo>();
        if (responseText.length() == 0) {
            return result.build();
        }
        Object object = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)responseText, (String[])object, (boolean)false, (int)0, (int)6, null);
        object = lines.iterator();
        int n = 0;
        while (object.hasNext()) {
            int lineIndex = n++;
            String line = (String)object.next();
            if (!(((CharSequence)line).length() > 0)) continue;
            oneLineParser2.call(result, lineIndex, line);
        }
        return result.build();
    }

    private final void parseOneShortFormatLine(ListWithErrors.Builder<DeviceInfo> result, int lineIndex, CharSequence lineText) {
        Matcher matcher = DeviceListParserKt.access$getSHORT_LINE_PATTERN$p().matcher(lineText);
        if (!matcher.matches()) {
            result.addError("Device line format is not recognized", lineIndex, ((Object)lineText).toString());
            return;
        }
        String serialNumber = matcher.group(1);
        if (serialNumber == null || ((CharSequence)serialNumber).length() == 0) {
            result.addError("Device serial number is empty", lineIndex, lineText);
            return;
        }
        String deviceState = matcher.group(2);
        if (deviceState == null || ((CharSequence)deviceState).length() == 0) {
            result.addError("Device state is empty", lineIndex, lineText);
            return;
        }
        result.addEntry(DeviceInfo.Companion.fromParserValues$android_sdktools_adblib$default(DeviceInfo.Companion, serialNumber, deviceState, null, null, null, null, null, 124, null));
    }

    private final void parseOneLongFormatLine(ListWithErrors.Builder<DeviceInfo> result, int lineIndex, CharSequence lineText) {
        Matcher matcher = DeviceListParserKt.access$getLONG_LINE_PATTERN$p().matcher(lineText);
        if (!matcher.matches()) {
            result.addError("Device line format is not recognized", lineIndex, lineText);
            return;
        }
        String serialNumber = matcher.group(1);
        if (serialNumber == null || ((CharSequence)serialNumber).length() == 0) {
            result.addError("Device serial number is empty", lineIndex, lineText);
            return;
        }
        String deviceState = matcher.group(2);
        if (deviceState == null || ((CharSequence)deviceState).length() == 0) {
            result.addError("Device state is empty", lineIndex, lineText);
            return;
        }
        String product = null;
        String model2 = null;
        String device2 = null;
        String transportId2 = null;
        Map moreFields = new LinkedHashMap();
        Matcher matcherFields = DeviceListParserKt.access$getONE_FIELD_PATTERN$p().matcher(lineText);
        block12: while (matcherFields.find()) {
            String value;
            String name;
            block20: {
                name = matcherFields.group(1);
                value = matcherFields.group(2);
                String string = name;
                if (string == null) break block20;
                int n = -1;
                switch (string.hashCode()) {
                    case -309474065: {
                        if (string.equals("product")) {
                            n = 1;
                        }
                        break;
                    }
                    case -1571176975: {
                        if (string.equals("transport_id")) {
                            n = 2;
                        }
                        break;
                    }
                    case 104069929: {
                        if (string.equals("model")) {
                            n = 3;
                        }
                        break;
                    }
                    case -1335157162: {
                        if (string.equals("device")) {
                            n = 4;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        product = value;
                        continue block12;
                    }
                    case 3: {
                        model2 = value;
                        continue block12;
                    }
                    case 4: {
                        device2 = value;
                        continue block12;
                    }
                    case 2: {
                        transportId2 = value;
                        continue block12;
                    }
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            moreFields.put(name, value);
        }
        DeviceInfo deviceInfo = DeviceInfo.Companion.fromParserValues$android_sdktools_adblib(serialNumber, deviceState, product, model2, device2, transportId2, moreFields.isEmpty() ? MapsKt.emptyMap() : moreFields);
        result.addEntry(deviceInfo);
    }

    public static final /* synthetic */ void access$parseOneShortFormatLine(DeviceListParser $this, ListWithErrors.Builder result, int lineIndex, CharSequence lineText) {
        $this.parseOneShortFormatLine(result, lineIndex, lineText);
    }

    public static final /* synthetic */ void access$parseOneLongFormatLine(DeviceListParser $this, ListWithErrors.Builder result, int lineIndex, CharSequence lineText) {
        $this.parseOneLongFormatLine(result, lineIndex, lineText);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J&\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b\u00c0\u0006\u0003"}, d2={"Lcom/android/adblib/impl/DeviceListParser$OneLineParser;", "", "call", "", "result", "Lcom/android/adblib/ListWithErrors$Builder;", "Lcom/android/adblib/DeviceInfo;", "lineIndex", "", "lineText", "", "android.sdktools.adblib"})
    public static interface OneLineParser {
        public void call(@NotNull ListWithErrors.Builder<DeviceInfo> var1, int var2, @NotNull CharSequence var3);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AdbHostServices.DeviceInfoFormat.values().length];
            nArray[AdbHostServices.DeviceInfoFormat.SHORT_FORMAT.ordinal()] = 1;
            nArray[AdbHostServices.DeviceInfoFormat.LONG_FORMAT.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

