/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.diagnostic.LoggerRt;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.Searcher;
import org.jetbrains.plugins.textmate.regex.StringWithId;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.WarnCallback;
import org.joni.exception.JOniException;

public final class RegexFacade {
    private static final Regex FAILED_REGEX = new Regex("^$", (Encoding)UTF8Encoding.INSTANCE);
    private static final LoggerRt LOGGER = LoggerRt.getInstance(RegexFacade.class);
    @NotNull
    private final Regex myRegex;
    private final boolean hasGMatch;
    private final ThreadLocal<LastMatch> matchResult = new ThreadLocal();
    private static final Cache<String, RegexFacade> REGEX_CACHE = Caffeine.newBuilder().maximumSize(100000L).expireAfterAccess(1L, TimeUnit.MINUTES).build();

    private RegexFacade(@NotNull String regexString) {
        Regex regex;
        byte[] bytes = regexString.getBytes(StandardCharsets.UTF_8);
        try {
            regex = new Regex(bytes, 0, bytes.length, 256, (Encoding)UTF8Encoding.INSTANCE, WarnCallback.NONE);
        }
        catch (JOniException e) {
            LOGGER.info("Failed to parse textmate regex", (Throwable)e);
            regex = FAILED_REGEX;
        }
        this.hasGMatch = regexString.contains("\\G");
        this.myRegex = regex;
    }

    public MatchData match(StringWithId string, @Nullable Runnable checkCancelledCallback) {
        return this.match(string, 0, 0, true, checkCancelledCallback);
    }

    public MatchData match(@NotNull StringWithId string, int byteOffset, int gosOffset, boolean matchBeginOfString, @Nullable Runnable checkCancelledCallback) {
        Matcher matcher;
        int matchIndex;
        MatchData lastMatch;
        gosOffset = gosOffset >= 0 ? gosOffset : byteOffset;
        int options = matchBeginOfString ? 0 : 65536;
        LastMatch lastResult = this.matchResult.get();
        Object lastId = lastResult != null ? lastResult.lastId : null;
        int lastOffset = lastResult != null ? lastResult.lastOffset : Integer.MAX_VALUE;
        int lastGosOffset = lastResult != null ? lastResult.lastGosOffset : -1;
        int lastOptions = lastResult != null ? lastResult.lastOptions : -1;
        MatchData matchData = lastMatch = lastResult != null ? lastResult.lastMatch : MatchData.NOT_MATCHED;
        if (!(lastId != string.id || lastOffset > byteOffset || lastOptions != options || this.hasGMatch && lastGosOffset != gosOffset || lastMatch.matched() && lastMatch.byteOffset().start < byteOffset)) {
            RegexFacade.checkMatched(lastMatch, string);
            return lastMatch;
        }
        if (checkCancelledCallback != null) {
            checkCancelledCallback.run();
        }
        MatchData matchData2 = (matchIndex = (matcher = this.myRegex.matcher(string.bytes)).search(gosOffset, byteOffset, string.bytes.length, options)) > -1 ? MatchData.fromRegion(matcher.getEagerRegion()) : MatchData.NOT_MATCHED;
        RegexFacade.checkMatched(matchData2, string);
        this.matchResult.set(new LastMatch(string.id, byteOffset, gosOffset, options, matchData2));
        return matchData2;
    }

    private static void checkMatched(MatchData match, StringWithId string) {
        if (match.matched() && match.byteOffset().end > string.bytes.length) {
            throw new IllegalStateException("Match data out of bounds: " + match.byteOffset().start + " > " + string.bytes.length + "\n" + new String(string.bytes, StandardCharsets.UTF_8));
        }
    }

    public Searcher searcher(byte[] stringBytes) {
        return new Searcher(stringBytes, this.myRegex.matcher(stringBytes, 0, stringBytes.length));
    }

    @NotNull
    public static RegexFacade regex(@NotNull String regexString) {
        return (RegexFacade)REGEX_CACHE.get((Object)regexString, RegexFacade::new);
    }

    private static final class LastMatch {
        private final Object lastId;
        private final int lastOffset;
        private final int lastGosOffset;
        private final int lastOptions;
        private final MatchData lastMatch;

        private LastMatch(Object id, int offset, int gosOffset, int options, MatchData data) {
            this.lastId = id;
            this.lastOffset = offset;
            this.lastGosOffset = gosOffset;
            this.lastOptions = options;
            this.lastMatch = data;
        }
    }
}

