/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.plist;

import com.intellij.openapi.util.text.Strings;
import com.intellij.util.xml.dom.XmlDomReader;
import com.intellij.util.xml.dom.XmlElement;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;
import org.jetbrains.plugins.textmate.plist.PlistValueType;

public class XmlPlistReader
implements PlistReader {
    @Override
    public Plist read(@NotNull InputStream inputStream) throws IOException {
        return XmlPlistReader.internalRead(XmlDomReader.readXmlAsModel((InputStream)inputStream));
    }

    private static Plist internalRead(@NotNull XmlElement root) throws IOException {
        if (root.children.isEmpty()) {
            return Plist.EMPTY_PLIST;
        }
        if (!"plist".equals(root.name)) {
            throw new IOException("Unknown xml format. Root element is '" + root.name + "'");
        }
        XmlElement dictElement = root.getChild("dict");
        return dictElement != null ? (Plist)XmlPlistReader.readDict(dictElement).getValue() : Plist.EMPTY_PLIST;
    }

    private static PListValue readDict(@NotNull XmlElement dictElement) throws IOException {
        Plist dict = new Plist();
        List children = dictElement.children;
        for (int i = 0; i < children.size(); ++i) {
            PListValue value;
            XmlElement keyElement = (XmlElement)children.get(i);
            if (!"key".equals(keyElement.name)) continue;
            String attributeKey = keyElement.content;
            PListValue pListValue = value = attributeKey != null ? XmlPlistReader.readValue(attributeKey, (XmlElement)children.get(++i)) : null;
            if (value == null) continue;
            dict.setEntry(attributeKey, value);
        }
        return PListValue.value(dict, PlistValueType.DICT);
    }

    @Nullable
    private static PListValue readValue(@NotNull String key, @NotNull XmlElement valueElement) throws IOException {
        String type = valueElement.name;
        if ("dict".equals(type)) {
            return XmlPlistReader.readDict(valueElement);
        }
        if ("array".equals(type)) {
            return XmlPlistReader.readArray(key, valueElement);
        }
        return XmlPlistReader.readBasicValue(type, valueElement);
    }

    private static PListValue readArray(String key, XmlElement element) throws IOException {
        ArrayList<PListValue> result = new ArrayList<PListValue>();
        for (XmlElement child : element.children) {
            PListValue val = XmlPlistReader.readValue(key, child);
            if (val == null) continue;
            result.add(val);
        }
        return PListValue.value(result, PlistValueType.ARRAY);
    }

    @Nullable
    private static PListValue readBasicValue(@NotNull String type, @NotNull XmlElement valueElement) throws IOException {
        String content = valueElement.content;
        if ("string".equals(type) && content != null) {
            return PListValue.value(Strings.unescapeXmlEntities((String)content), PlistValueType.STRING);
        }
        if ("true".equals(type)) {
            return PListValue.value(Boolean.TRUE, PlistValueType.BOOLEAN);
        }
        if ("false".equals(type)) {
            return PListValue.value(Boolean.FALSE, PlistValueType.BOOLEAN);
        }
        if ("integer".equals(type) && content != null) {
            return PListValue.value(Long.parseLong(content), PlistValueType.INTEGER);
        }
        if ("real".equals(type) && content != null) {
            return PListValue.value(Double.parseDouble(content), PlistValueType.REAL);
        }
        if ("date".equals(type) && content != null) {
            try {
                return PListValue.value(Plist.dateFormatter().parse(content), PlistValueType.DATE);
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        return null;
    }
}

