/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.selector;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class TextMateWeigh
implements Comparable<TextMateWeigh> {
    public static final TextMateWeigh ZERO = new TextMateWeigh(0, Priority.LOW);
    public final int weigh;
    @NotNull
    public final Priority priority;

    public TextMateWeigh(int weigh, @NotNull Priority priority) {
        this.weigh = weigh;
        this.priority = priority;
    }

    @Override
    public int compareTo(@NotNull TextMateWeigh o) {
        int priorityCompare = this.priority.compareTo(o.priority);
        if (priorityCompare != 0) {
            return priorityCompare;
        }
        return Integer.compare(this.weigh, o.weigh);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextMateWeigh weigh1 = (TextMateWeigh)o;
        return this.weigh == weigh1.weigh && this.priority == weigh1.priority;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.weigh, this.priority});
    }

    public static enum Priority {
        LOW,
        NORMAL,
        HIGH;

    }
}

