/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.selector;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorToken;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;

public final class TextMateSelectorLexer {
    public static List<TextMateSelectorToken> tokenize(@NotNull CharSequence selector) {
        ArrayList<TextMateSelectorToken> result = new ArrayList<TextMateSelectorToken>();
        StringBuilder currentSelector = new StringBuilder();
        for (int i = 0; i < selector.length(); ++i) {
            char c = selector.charAt(i);
            if (c == '(') {
                currentSelector = TextMateSelectorLexer.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.LPAREN);
                continue;
            }
            if (c == ')') {
                currentSelector = TextMateSelectorLexer.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.RPAREN);
                continue;
            }
            if (c == ',') {
                currentSelector = TextMateSelectorLexer.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.COMMA);
                continue;
            }
            if (c == '|') {
                currentSelector = TextMateSelectorLexer.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.PIPE);
                continue;
            }
            if (c == '^') {
                currentSelector = TextMateSelectorLexer.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.HAT);
                continue;
            }
            if (c == '-') {
                currentSelector = TextMateSelectorLexer.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.MINUS);
                continue;
            }
            if (c == ' ') {
                currentSelector = TextMateSelectorLexer.addPendingToken(result, currentSelector);
                continue;
            }
            if ((c == 'R' || c == 'L' || c == 'B') && i + 1 < selector.length() && selector.charAt(i + 1) == ':') {
                currentSelector = TextMateSelectorLexer.addPendingToken(result, currentSelector);
                ++i;
                if (c == 'R') {
                    result.add(new PriorityToken(TextMateWeigh.Priority.LOW));
                    continue;
                }
                if (c != 'L') continue;
                result.add(new PriorityToken(TextMateWeigh.Priority.LOW));
                continue;
            }
            currentSelector.append(c);
        }
        TextMateSelectorLexer.addPendingToken(result, currentSelector);
        return result;
    }

    @NotNull
    private static StringBuilder addPendingToken(ArrayList<TextMateSelectorToken> result, StringBuilder currentSelector) {
        if (currentSelector.length() > 0) {
            result.add(new SelectorToken(currentSelector.toString()));
            return new StringBuilder();
        }
        return currentSelector;
    }

    public static class SelectorToken
    implements TextMateSelectorToken {
        private final String myText;

        public SelectorToken(String text) {
            this.myText = text;
        }

        public String getText() {
            return this.myText;
        }

        public String toString() {
            return this.myText;
        }
    }

    public static class PriorityToken
    implements TextMateSelectorToken {
        private final TextMateWeigh.Priority myPriority;

        public PriorityToken(TextMateWeigh.Priority priority) {
            this.myPriority = priority;
        }

        public TextMateWeigh.Priority getPriority() {
            return this.myPriority;
        }

        public String toString() {
            return this.myPriority.name();
        }
    }

    public static class SignToken
    implements TextMateSelectorToken {
        private final char mySign;

        public SignToken(char c) {
            this.mySign = c;
        }

        public String toString() {
            return String.valueOf(this.mySign);
        }
    }
}

