/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.selector;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;

public class TextMateSelectorCachingWeigher
implements TextMateSelectorWeigher {
    @NotNull
    private final TextMateSelectorWeigher myOriginalWeigher;
    private final Cache<@NotNull CacheKey, @NotNull TextMateWeigh> myCache;

    public TextMateSelectorCachingWeigher(@NotNull TextMateSelectorWeigher originalWeigher) {
        this.myOriginalWeigher = originalWeigher;
        this.myCache = Caffeine.newBuilder().maximumSize(100000L).expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }

    @Override
    public TextMateWeigh weigh(@NotNull CharSequence scopeSelector, @NotNull TextMateScope scope) {
        return (TextMateWeigh)this.myCache.get((Object)new CacheKey(scopeSelector, scope), this::weigh);
    }

    private TextMateWeigh weigh(@NotNull CacheKey pair) {
        return this.myOriginalWeigher.weigh(pair.selector, pair.scope);
    }

    private static final class CacheKey {
        final CharSequence selector;
        final TextMateScope scope;

        private CacheKey(CharSequence selector, TextMateScope scope) {
            this.selector = selector;
            this.scope = scope;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey key = (CacheKey)o;
            return this.selector.equals(key.selector) && this.scope.equals(key.scope);
        }

        public int hashCode() {
            return Objects.hash(this.selector, this.scope);
        }
    }
}

