/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.highlighting;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateHighlighter;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateHighlightingLexer;

public class TextMateSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    private static final SyntaxHighlighter PLAIN_SYNTAX_HIGHLIGHTER = new TextMateHighlighter(null);
    private static final Logger LOG = Logger.getInstance(TextMateSyntaxHighlighterFactory.class);

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        TextMateLanguageDescriptor languageDescriptor;
        if (virtualFile == null) {
            return PLAIN_SYNTAX_HIGHLIGHTER;
        }
        TextMateService textMateService = TextMateService.getInstance();
        if (textMateService != null && (languageDescriptor = textMateService.getLanguageDescriptorByFileName(virtualFile.getName())) != null) {
            LOG.debug("Textmate highlighting: " + virtualFile.getPath());
            return new TextMateHighlighter((Lexer)new TextMateHighlightingLexer(languageDescriptor, Registry.get((String)"textmate.line.highlighting.limit").asInteger()));
        }
        return PLAIN_SYNTAX_HIGHLIGHTER;
    }
}

