/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxProxyDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTable;

public class SyntaxScopeProxyDescriptor
extends SyntaxProxyDescriptor {
    @NotNull
    private final CharSequence myScope;
    @NotNull
    private final TextMateSyntaxTable mySyntaxTable;
    private final int myRuleId;

    SyntaxScopeProxyDescriptor(@NotNull CharSequence scope, int ruleId, @NotNull TextMateSyntaxTable syntaxTable, @NotNull SyntaxNodeDescriptor parentNode) {
        super(parentNode);
        this.myScope = scope;
        this.myRuleId = ruleId;
        this.mySyntaxTable = syntaxTable;
    }

    @Override
    protected SyntaxNodeDescriptor computeTargetNode() {
        SyntaxNodeDescriptor parentNode = this.mySyntaxTable.getSyntax(this.myScope);
        return this.myRuleId > -1 ? parentNode.findInRepository(this.myRuleId) : parentNode;
    }

    public String toString() {
        return "Proxy rule for '" + this.myScope + "[" + this.myRuleId + "]' scope";
    }
}

