/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public class ShellVariablesRegistry {
    @NotNull
    private final Map<String, Collection<TextMateShellVariable>> myVariables = new HashMap<String, Collection<TextMateShellVariable>>();

    public void fillVariablesFromPlist(@NotNull CharSequence scopeName, @NotNull Plist plist) {
        PListValue shellVariables = plist.getPlistValue("shellVariables");
        if (shellVariables != null) {
            for (PListValue variable : shellVariables.getArray()) {
                Plist variablePlist = variable.getPlist();
                String name = variablePlist.getPlistValue("name", "").getString();
                String value = variablePlist.getPlistValue("value", "").getString();
                if (name.isEmpty()) continue;
                this.myVariables.computeIfAbsent(name, key -> new ArrayList()).add(new TextMateShellVariable(scopeName, name, value));
            }
        }
    }

    @Nullable
    public TextMateShellVariable getVariableValue(@NotNull String name, @Nullable TextMateScope scope) {
        if (scope == null) {
            return null;
        }
        Collection<TextMateShellVariable> variables = this.myVariables.get(name);
        if (variables == null) {
            return null;
        }
        return new TextMateScopeComparator<TextMateShellVariable>(scope, TextMateShellVariable::getScopeSelector).max(variables);
    }

    public void clear() {
        this.myVariables.clear();
    }
}

