/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum BundleType {
    TEXTMATE("Syntaxes", "Preferences", "Snippets", "tmsnippet", "plist"),
    SUBLIME("", "", "", "sublime-snippet"),
    VSCODE("syntaxes", "", "snippets", "json"),
    UNDEFINED;

    private final String mySyntaxesPath;
    private final String myPreferencesPath;
    private final String mySnippetsPath;
    private final String[] mySnippetFileExtensions;

    private BundleType() {
        this("", "", "", new String[0]);
    }

    private BundleType(@NotNull String syntaxesPath, String preferencesPath, String snippetsPath, String ... snippetFileExtension) {
        this.mySyntaxesPath = syntaxesPath;
        this.myPreferencesPath = preferencesPath;
        this.mySnippetsPath = snippetsPath;
        this.mySnippetFileExtensions = snippetFileExtension;
    }

    @NotNull
    String getPreferencesPath() {
        return this.myPreferencesPath;
    }

    @NotNull
    String getSyntaxesPath() {
        return this.mySyntaxesPath;
    }

    @NotNull
    String getSnippetsPath() {
        return this.mySnippetsPath;
    }

    String @NotNull [] getSnippetFileExtensions() {
        return this.mySnippetFileExtensions;
    }

    @NotNull
    static BundleType fromDirectory(@Nullable File directory) {
        if (directory != null && directory.exists() && directory.isDirectory()) {
            if ("tmBundle".equalsIgnoreCase(FileUtilRt.getExtension((String)directory.getName()))) {
                return TEXTMATE;
            }
            File packageJson = new File(directory, "package.json");
            if (packageJson.exists() && packageJson.isFile()) {
                return VSCODE;
            }
            File infoPlist = new File(directory, "info.plist");
            boolean hasInfoPlistFile = infoPlist.exists() && infoPlist.isFile();
            File[] children = directory.listFiles();
            if (children != null) {
                for (File child : children) {
                    if (hasInfoPlistFile && child.isDirectory() && "Syntaxes".equalsIgnoreCase(child.getName())) {
                        return TEXTMATE;
                    }
                    String fileExtension = FileUtilRt.getExtension((String)child.getName());
                    if (!"tmLanguage".equalsIgnoreCase(fileExtension) && !"tmPreferences".equalsIgnoreCase(fileExtension)) continue;
                    return SUBLIME;
                }
            }
            if (hasInfoPlistFile) {
                return TEXTMATE;
            }
        }
        return UNDEFINED;
    }
}

