/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

public abstract class YamlScalarTextEvaluator<T extends YAMLScalarImpl> {
    @NotNull
    protected final T myHost;

    public YamlScalarTextEvaluator(@NotNull T host) {
        this.myHost = host;
    }

    @NotNull
    public abstract List<TextRange> getContentRanges();

    @NotNull
    protected abstract String getRangesJoiner(@NotNull CharSequence var1, @NotNull List<TextRange> var2, int var3);

    @NotNull
    public String getTextValue(@Nullable TextRange rangeInHost) {
        String text = this.myHost.getText();
        List<TextRange> contentRanges2 = this.getContentRanges();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < contentRanges2.size(); ++i) {
            TextRange range;
            TextRange textRange = range = rangeInHost != null ? rangeInHost.intersection(contentRanges2.get(i)) : contentRanges2.get(i);
            if (range == null) continue;
            CharSequence curString = range.subSequence((CharSequence)text);
            builder.append(curString);
            if (range.getEndOffset() != contentRanges2.get(i).getEndOffset() || i + 1 == contentRanges2.size()) continue;
            builder.append(this.getRangesJoiner(text, contentRanges2, i));
        }
        return YAMLScalarImpl.processReplacements(builder, ((YAMLScalarImpl)this.myHost).getDecodeReplacements(builder));
    }
}

