/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.lexer.YAMLGrammarCharUtil;
import org.jetbrains.yaml.psi.impl.YAMLQuotedTextImpl;
import org.jetbrains.yaml.psi.impl.YamlScalarTextEvaluator;

class YAMLQuotedTextTextEvaluator
extends YamlScalarTextEvaluator<YAMLQuotedTextImpl> {
    YAMLQuotedTextTextEvaluator(YAMLQuotedTextImpl text) {
        super(text);
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        ASTNode firstContentNode = ((YAMLQuotedTextImpl)this.myHost).getFirstContentNode();
        if (firstContentNode == null) {
            return Collections.emptyList();
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        TextRange contentRange = TextRange.create((int)firstContentNode.getStartOffset(), (int)((YAMLQuotedTextImpl)this.myHost).getTextRange().getEndOffset()).shiftRight(-((YAMLQuotedTextImpl)this.myHost).getTextRange().getStartOffset());
        List lines = StringUtil.split((String)contentRange.substring(((YAMLQuotedTextImpl)this.myHost).getText()), (String)"\n", (boolean)true, (boolean)false);
        int cumulativeOffset = contentRange.getStartOffset();
        for (int i = 0; i < lines.size(); ++i) {
            int lineStart;
            String line = (String)lines.get(i);
            int lineEnd = line.length();
            if (i == 0) {
                ++lineStart;
            } else {
                for (lineStart = 0; lineStart < line.length() && YAMLGrammarCharUtil.isSpaceLike(line.charAt(lineStart)); ++lineStart) {
                }
            }
            if (i == lines.size() - 1) {
                --lineEnd;
            } else {
                while (lineEnd > lineStart && YAMLGrammarCharUtil.isSpaceLike(line.charAt(lineEnd - 1))) {
                    --lineEnd;
                }
            }
            result.add(TextRange.create((int)lineStart, (int)lineEnd).shiftRight(cumulativeOffset));
            cumulativeOffset += line.length() + 1;
        }
        return result;
    }

    @Override
    @NotNull
    protected String getRangesJoiner(@NotNull CharSequence text, @NotNull List<TextRange> contentRanges2, int indexBefore) {
        TextRange leftRange = contentRanges2.get(indexBefore);
        if (leftRange.isEmpty() || !((YAMLQuotedTextImpl)this.myHost).isSingleQuote() && text.charAt(leftRange.getEndOffset() - 1) == '\\') {
            return "\n";
        }
        if (contentRanges2.get(indexBefore + 1).isEmpty()) {
            return "";
        }
        return " ";
    }
}

