/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImpl;
import org.jetbrains.yaml.psi.impl.YamlScalarTextEvaluator;

public class YAMLPlainTextImpl
extends YAMLBlockScalarImpl
implements YAMLScalar {
    public YAMLPlainTextImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    protected IElementType getContentType() {
        return YAMLTokenTypes.TEXT;
    }

    @Override
    protected boolean getIncludeFirstLineInContent() {
        return true;
    }

    @Override
    @NotNull
    public YamlScalarTextEvaluator getTextEvaluator() {
        return new YamlScalarTextEvaluator<YAMLPlainTextImpl>(this){

            @Override
            @NotNull
            public List<TextRange> getContentRanges() {
                int myStart = YAMLPlainTextImpl.this.getTextRange().getStartOffset();
                ArrayList<TextRange> result = new ArrayList<TextRange>();
                boolean seenText = false;
                for (ASTNode child = YAMLPlainTextImpl.this.getFirstContentNode(); child != null; child = child.getTreeNext()) {
                    if (child.getElementType() == YAMLTokenTypes.TEXT) {
                        seenText = true;
                        result.add(child.getTextRange().shiftRight(-myStart));
                        continue;
                    }
                    if (child.getElementType() != YAMLTokenTypes.EOL) continue;
                    if (!seenText) {
                        result.add(child.getTextRange().shiftRight(-myStart));
                    }
                    seenText = false;
                }
                return result;
            }

            @Override
            @NotNull
            protected String getRangesJoiner(@NotNull CharSequence text, @NotNull List<TextRange> contentRanges2, int indexBefore) {
                if (this.isNewline(text, contentRanges2.get(indexBefore)) || this.isNewline(text, contentRanges2.get(indexBefore + 1))) {
                    return "";
                }
                return " ";
            }

            private boolean isNewline(@NotNull CharSequence text, @NotNull TextRange range) {
                return range.getLength() == 1 && text.charAt(range.getStartOffset()) == '\n';
            }
        };
    }

    @Override
    public String toString() {
        return "YAML plain scalar text";
    }

    @Override
    public boolean isMultiline() {
        return this.getNode().findChildByType((IElementType)YAMLTokenTypes.EOL) != null;
    }
}

