/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImplKt;
import org.jetbrains.yaml.psi.impl.YamlScalarTextEvaluator;

public abstract class YAMLBlockScalarTextEvaluator<T extends YAMLBlockScalarImpl>
extends YamlScalarTextEvaluator<T> {
    public YAMLBlockScalarTextEvaluator(@NotNull T host) {
        super(host);
    }

    protected boolean shouldIncludeEolInRange(ASTNode child) {
        return YAMLBlockScalarImplKt.isEol(child) && child.getTreeNext() == null && this.getChompingIndicator() == ChompingIndicator.KEEP;
    }

    protected boolean isEnding(@Nullable TextRange rangeInHost) {
        if (rangeInHost == null) {
            return true;
        }
        TextRange lastItem = (TextRange)ContainerUtil.getLastItem(this.getContentRanges());
        if (lastItem == null) {
            return false;
        }
        return rangeInHost.getEndOffset() == lastItem.getEndOffset();
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        ChompingIndicator chomping;
        ASTNode firstContentChild = ((YAMLBlockScalarImpl)this.myHost).getFirstContentNode();
        if (firstContentChild == null) {
            return Collections.emptyList();
        }
        int myStart = ((YAMLBlockScalarImpl)this.myHost).getTextRange().getStartOffset();
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        int indent = ((YAMLBlockScalarImpl)this.myHost).locateIndent();
        ASTNode firstEol = TreeUtil.findSibling((ASTNode)firstContentChild, (TokenSet)YAMLElementTypes.EOL_ELEMENTS);
        if (firstEol == null) {
            return Collections.emptyList();
        }
        int thisLineStart = firstEol.getStartOffset() + 1;
        for (ASTNode child = firstEol.getTreeNext(); child != null; child = child.getTreeNext()) {
            int endOffset;
            IElementType childType = child.getElementType();
            TextRange childRange = child.getTextRange();
            if (childType == YAMLTokenTypes.INDENT && YAMLBlockScalarImplKt.isEol(child.getTreePrev())) {
                thisLineStart = child.getStartOffset() + Math.min(indent, child.getTextLength());
                continue;
            }
            if (childType == YAMLTokenTypes.SCALAR_EOL) {
                if (thisLineStart != -1) {
                    endOffset = this.shouldIncludeEolInRange(child) ? child.getTextRange().getEndOffset() : child.getStartOffset();
                    result.add(TextRange.create((int)thisLineStart, (int)endOffset).shiftRight(-myStart));
                }
                thisLineStart = child.getStartOffset() + 1;
                continue;
            }
            if (!YAMLBlockScalarImplKt.isEol(child.getTreeNext())) continue;
            if (thisLineStart == -1) {
                Logger.getInstance(YAMLBlockScalarTextEvaluator.class).warn("thisLineStart == -1: '" + ((YAMLBlockScalarImpl)this.myHost).getText() + "'", new Throwable());
                continue;
            }
            endOffset = this.shouldIncludeEolInRange(child) ? child.getTreeNext().getTextRange().getEndOffset() : childRange.getEndOffset();
            result.add(TextRange.create((int)thisLineStart, (int)endOffset).shiftRight(-myStart));
            thisLineStart = -1;
        }
        if (thisLineStart != -1) {
            result.add(TextRange.create((int)thisLineStart, (int)((YAMLBlockScalarImpl)this.myHost).getTextRange().getEndOffset()).shiftRight(-myStart));
        }
        if ((chomping = this.getChompingIndicator()) == ChompingIndicator.KEEP) {
            return result;
        }
        int lastNonEmpty = ContainerUtil.lastIndexOf(result, range -> range.getLength() != 0);
        return lastNonEmpty == -1 ? Collections.emptyList() : result.subList(0, lastNonEmpty + 1);
    }

    @NotNull
    protected final ChompingIndicator getChompingIndicator() {
        ASTNode headerNode = ((YAMLBlockScalarImpl)this.myHost).getNthContentTypeChild(0);
        assert (headerNode != null);
        String header = headerNode.getText();
        if (header.contains("+")) {
            return ChompingIndicator.KEEP;
        }
        if (header.contains("-")) {
            return ChompingIndicator.STRIP;
        }
        return ChompingIndicator.CLIP;
    }

    @Contract(value="null -> true")
    public static boolean isEolOrNull(@Nullable ASTNode node) {
        if (node == null) {
            return true;
        }
        return YAMLElementTypes.EOL_ELEMENTS.contains(node.getElementType());
    }

    protected static enum ChompingIndicator {
        CLIP,
        STRIP,
        KEEP;

    }
}

