/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.psi.impl.YAMLPsiElementImpl;

public class YAMLAnchorImpl
extends YAMLPsiElementImpl
implements YAMLAnchor {
    public YAMLAnchorImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public String getName() {
        return this.getNameIdentifier().getText();
    }

    @NotNull
    public PsiElement getNameIdentifier() {
        return this.getLastChild();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this.getNameIdentifier();
    }

    public int getTextOffset() {
        return this.getNavigationElement().getNode().getStartOffset();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        PsiElement nameIdentifier = this.getNameIdentifier();
        assert (nameIdentifier instanceof LeafPsiElement);
        ((LeafPsiElement)nameIdentifier).replaceWithText(name);
        return this;
    }

    @Override
    @Nullable
    public YAMLValue getMarkedValue() {
        PsiElement parent = this.getParent();
        if (parent instanceof YAMLValue) {
            return (YAMLValue)parent;
        }
        return null;
    }

    @Override
    public String toString() {
        return "YAML anchor";
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof YamlPsiElementVisitor) {
            ((YamlPsiElementVisitor)visitor).visitAnchor(this);
        } else {
            super.accept(visitor);
        }
    }
}

