/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.impl.YamlMetaUtil;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlBooleanType;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.meta.model.YamlStringType;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Internal
public class YamlMetaClass
extends YamlMetaType {
    private final List<Field> myFeatures = new LinkedList<Field>();
    private final List<Field> myFeaturesRO = Collections.unmodifiableList(this.myFeatures);

    public YamlMetaClass(@NonNls @NotNull String typeName) {
        super(typeName);
    }

    @Override
    @Nullable
    public Field findFeatureByName(@NotNull String name) {
        if (this.getFeatures().isEmpty()) {
            return null;
        }
        Optional<Field> byExactName = this.getFeatures().stream().filter(f -> !f.isByPattern() && name.equals(f.getName())).findAny();
        return byExactName.orElse((Field)ContainerUtil.find(this.getFeatures(), f -> f.isByPattern() && f.acceptsFieldName(name)));
    }

    @Override
    @NotNull
    public List<String> computeMissingFields(@NotNull Set<String> existingFields) {
        return this.myFeatures.stream().filter(Field::isRequired).map(Field::getName).filter(name -> !existingFields.contains(name)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<Field> computeKeyCompletions(@Nullable YAMLMapping existingMapping) {
        return ContainerUtil.filter(this.myFeatures, Field::isEditable);
    }

    @NotNull
    public List<Field> getFeatures() {
        return this.myFeaturesRO;
    }

    @NotNull
    protected final Field addStringFeature(@NotNull String name) {
        return this.addFeature(new Field(name, YamlStringType.getInstance()));
    }

    @NotNull
    protected Field addBooleanFeature(@NotNull String name) {
        return this.addScalarFeature(name, YamlBooleanType.getSharedInstance());
    }

    @NotNull
    protected final Field addScalarFeature(@NotNull YamlScalarType type) {
        return this.addScalarFeature(type.getTypeName(), type);
    }

    @NotNull
    protected final Field addScalarFeature(@NotNull String name, @NotNull YamlScalarType type) {
        return this.addFeature(new Field(name, type));
    }

    @NotNull
    protected final Field addObjectFeature(@NotNull YamlMetaClass metaClass) {
        return this.addFeature(new Field(metaClass.getTypeName(), metaClass));
    }

    protected <T extends Field> T addFeature(@NotNull T child) {
        this.myFeatures.add(child);
        return child;
    }

    @Override
    public void buildInsertionSuffixMarkup(@NotNull YamlMetaType.YamlInsertionMarkup markup, @NotNull Field.Relation relation, @NotNull YamlMetaType.ForcedCompletionPath.Iteration iteration) {
        switch (relation) {
            case SCALAR_VALUE: {
                throw new IllegalArgumentException("Default relation " + relation + " requested for complex type: " + this);
            }
            case OBJECT_CONTENTS: {
                this.doBuildInsertionSuffixMarkup(markup, false, iteration);
                break;
            }
            case SEQUENCE_ITEM: {
                this.doBuildInsertionSuffixMarkup(markup, true, iteration);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown relation: " + relation);
            }
        }
    }

    @Override
    public void validateValue(@NotNull YAMLValue value, @NotNull ProblemsHolder problemsHolder) {
        super.validateValue(value, problemsHolder);
        if (value instanceof YAMLScalar && !YamlMetaUtil.isNull(value)) {
            problemsHolder.registerProblem((PsiElement)value, YAMLBundle.message("YamlMetaClass.error.scalar.value", ArrayUtil.EMPTY_OBJECT_ARRAY), new LocalQuickFix[0]);
        }
    }

    private void doBuildInsertionSuffixMarkup(@NotNull YamlMetaType.YamlInsertionMarkup markup, boolean manyNotOne, @NotNull YamlMetaType.ForcedCompletionPath.Iteration iteration) {
        markup.append(":");
        markup.doTabbedBlock(manyNotOne ? 2 : 1, () -> {
            markup.newLineAndTabs(manyNotOne);
            List allRequired = ContainerUtil.filter(this.myFeatures, field -> field.isRequired() || iteration.isNextOnPath((Field)field));
            if (allRequired.isEmpty() && iteration.isEndOfPathReached()) {
                markup.appendCaret();
            } else {
                Iterator iterator = allRequired.iterator();
                while (iterator.hasNext()) {
                    Field field2 = (Field)iterator.next();
                    YamlMetaClass.buildCompleteKeyMarkup(markup, field2, iteration.nextIterationFor(field2));
                    if (!iterator.hasNext()) continue;
                    markup.newLineAndTabs();
                }
            }
        });
    }
}

