/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLMapping;

public abstract class YamlComposedTypeBase
extends YamlMetaType {
    private final List<YamlMetaType> myTypes;
    private final Map<String, Field> myFields = new HashMap<String, Field>();

    protected static List<YamlMetaType> flattenTypes(YamlMetaType ... types) {
        if (types.length == 0) {
            throw new IllegalArgumentException("Nothing to compose");
        }
        SmartList flattenedTypes = new SmartList();
        ReferenceOpenHashSet cerber = new ReferenceOpenHashSet();
        for (YamlMetaType next : types) {
            if (!cerber.add(next)) continue;
            if (next instanceof YamlScalarType) {
                flattenedTypes.add(next);
                continue;
            }
            if (next instanceof YamlComposedTypeBase) {
                YamlComposedTypeBase that = (YamlComposedTypeBase)next;
                flattenedTypes.addAll(that.myTypes);
                continue;
            }
            flattenedTypes.add(next);
        }
        return flattenedTypes;
    }

    protected abstract YamlMetaType composeTypes(YamlMetaType ... var1);

    protected YamlComposedTypeBase(@NotNull String typeName, List<YamlMetaType> types) {
        super(typeName);
        assert (types.size() > 1) : "Nothing to compose: " + types;
        this.myTypes = YamlComposedTypeBase.copyList(types);
    }

    @Override
    @Nullable
    public Field findFeatureByName(@NotNull String name) {
        if (!this.myFields.containsKey(name)) {
            SmartList fields = new SmartList();
            for (YamlMetaType nextSubType : this.myTypes) {
                Field nextField;
                if (nextSubType instanceof YamlScalarType || (nextField = nextSubType.findFeatureByName(name)) != null && !name.equals(nextField.getName()) || nextField == null) continue;
                fields.add(Pair.create((Object)nextField, (Object)nextSubType));
            }
            Field result = this.mergeFields((List<Pair<Field, YamlMetaType>>)fields);
            this.myFields.put(name, result);
        }
        return this.myFields.get(name);
    }

    @Override
    @NotNull
    public List<String> computeMissingFields(@NotNull Set<String> existingFields) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (YamlMetaType next : this.myTypes) {
            if (next instanceof YamlScalarType) continue;
            List<String> nextMissing = next.computeMissingFields(existingFields);
            if (nextMissing.isEmpty()) {
                return Collections.emptyList();
            }
            result.addAll(nextMissing);
        }
        return new LinkedList<String>(result);
    }

    @Override
    @NotNull
    public List<Field> computeKeyCompletions(@Nullable YAMLMapping existingMapping) {
        HashSet<String> processedNames = new HashSet<String>();
        LinkedHashSet<Field> result = new LinkedHashSet<Field>();
        for (YamlMetaType nextSubType : this.myTypes) {
            if (nextSubType instanceof YamlScalarType) continue;
            List<Field> subTypeCompletions = nextSubType.computeKeyCompletions(existingMapping);
            for (Field nextField : subTypeCompletions) {
                String nextFieldName = nextField.getName();
                if (processedNames.contains(nextFieldName)) continue;
                Field mergedField = this.findFeatureByName(nextFieldName);
                processedNames.add(nextFieldName);
                result.add(mergedField);
            }
        }
        return new LinkedList<Field>(result);
    }

    @Override
    public void buildInsertionSuffixMarkup(@NotNull YamlMetaType.YamlInsertionMarkup markup, @NotNull Field.Relation relation, @NotNull YamlMetaType.ForcedCompletionPath.Iteration iteration) {
        if (relation == Field.Relation.SCALAR_VALUE || relation == Field.Relation.OBJECT_CONTENTS && !this.listScalarSubTypes().isEmpty()) {
            markup.append(": ");
        } else {
            markup.append(":");
            if (relation == Field.Relation.SEQUENCE_ITEM) {
                markup.doTabbedBlockForSequenceItem();
            } else {
                markup.increaseTabs(1);
                markup.newLineAndTabs();
            }
        }
        markup.appendCaret();
    }

    protected final List<YamlMetaType> listScalarSubTypes() {
        return ContainerUtil.filter(this.myTypes, next -> next instanceof YamlScalarType);
    }

    protected final List<YamlMetaType> listNonScalarSubTypes() {
        return ContainerUtil.filter(this.myTypes, next -> !(next instanceof YamlScalarType));
    }

    public final Iterable<YamlMetaType> getSubTypes() {
        return YamlComposedTypeBase.copyList(this.myTypes);
    }

    protected final Stream<YamlMetaType> streamSubTypes() {
        return this.myTypes.stream();
    }

    private static <T> List<T> copyList(@NotNull List<T> list) {
        return list.isEmpty() ? Collections.emptyList() : new ArrayList<T>(list);
    }

    @Nullable
    private Field mergeFields(@NotNull List<Pair<Field, YamlMetaType>> pairs) {
        switch (pairs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Field)pairs.get(0).getFirst();
            }
        }
        Set allNames = pairs.stream().map(fieldAndType -> ((Field)fieldAndType.getFirst()).getName()).collect(Collectors.toSet());
        assert (allNames.size() == 1) : "Can't merge fields with different names: " + allNames;
        String theName = ((Field)pairs.get(0).getFirst()).getName();
        boolean isMany = YamlComposedTypeBase.mergeIsMany(theName, pairs);
        List fields = ContainerUtil.map(pairs, pair -> (Field)pair.getFirst());
        boolean required = fields.stream().allMatch(f -> f.isRequired());
        boolean deprecated = fields.stream().allMatch(f -> f.isDeprecated());
        boolean editable = fields.stream().anyMatch(f -> f.isEditable());
        boolean emptyAllowed = fields.stream().anyMatch(f -> f.isEmptyValueAllowed());
        boolean anyName = fields.stream().anyMatch(f -> f.isAnyNameAllowed());
        YamlMetaType type = this.composeTypes((YamlMetaType[])pairs.stream().map(p -> (YamlMetaType)p.getSecond()).toArray(YamlMetaType[]::new));
        Field result = new Field(theName, type);
        result.withMultiplicityManyNotOne(isMany);
        if (required) {
            result.setRequired();
        }
        if (deprecated) {
            result.setDeprecated();
        }
        if (!editable) {
            result.setNonEditable();
        }
        result.withEmptyValueAllowed(emptyAllowed);
        if (anyName) {
            result.withAnyName();
        }
        return result;
    }

    private static boolean mergeIsMany(@NotNull String name, @NotNull List<Pair<Field, YamlMetaType>> fields) {
        Map byMultiplicity = fields.stream().collect(Collectors.groupingBy(fieldAndType -> ((Field)fieldAndType.getFirst()).isMany(), Collectors.mapping(fieldAndType -> (YamlMetaType)fieldAndType.getSecond(), Collectors.toList())));
        List forMany = byMultiplicity.getOrDefault(Boolean.TRUE, Collections.emptyList());
        List forSingle = byMultiplicity.getOrDefault(Boolean.FALSE, Collections.emptyList());
        if (!forMany.isEmpty() && !forSingle.isEmpty()) {
            throw new IllegalArgumentException("Can't merge field " + name + ", it is many for: " + forMany + " but singular for: " + forSingle);
        }
        return forSingle.isEmpty();
    }

    protected static ProblemsHolder makeCopy(@NotNull ProblemsHolder original) {
        return new ProblemsHolder(original.getManager(), original.getFile(), original.isOnTheFly());
    }
}

