/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.CompletionContext;
import org.jetbrains.yaml.meta.model.YamlComposedTypeBase;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

public class YamlAnyOfType
extends YamlComposedTypeBase {
    public static YamlMetaType anyOf(YamlMetaType ... types) {
        if (types.length == 0) {
            throw new IllegalArgumentException();
        }
        if (types.length == 1) {
            return types[0];
        }
        String name = "AnyOf[" + Stream.of(types).map(YamlMetaType::getDisplayName).collect(Collectors.joining()) + "]";
        return new YamlAnyOfType(name, YamlAnyOfType.flattenTypes(types));
    }

    @Override
    protected YamlMetaType composeTypes(YamlMetaType ... types) {
        return YamlAnyOfType.anyOf(types);
    }

    protected YamlAnyOfType(@NotNull String typeName, List<YamlMetaType> types) {
        super(typeName, types);
    }

    @Override
    public void validateKey(@NotNull YAMLKeyValue keyValue, @NotNull ProblemsHolder problemsHolder) {
        List<ProblemsHolder> allProblems = YamlAnyOfType.allProblemsOrEmpty(problemsHolder, this.listNonScalarSubTypes(), (nextType, nextHolder) -> nextType.validateKey(keyValue, (ProblemsHolder)nextHolder));
        allProblems.stream().flatMap(h -> h.getResults().stream()).forEach(arg_0 -> ((ProblemsHolder)problemsHolder).registerProblem(arg_0));
    }

    @Override
    public void validateValue(@NotNull YAMLValue value, @NotNull ProblemsHolder problemsHolder) {
        List<YamlMetaType> types;
        if (value instanceof YAMLScalar) {
            types = this.listScalarSubTypes();
            if (types.isEmpty()) {
                types = Collections.singletonList(this.listNonScalarSubTypes().get(0));
            }
        } else {
            types = this.listNonScalarSubTypes();
            if (types.isEmpty()) {
                types = Collections.singletonList(this.listScalarSubTypes().get(0));
            }
        }
        List<ProblemsHolder> allProblems = YamlAnyOfType.allProblemsOrEmpty(problemsHolder, types, (nextType, nextHolder) -> nextType.validateValue(value, (ProblemsHolder)nextHolder));
        allProblems.stream().flatMap(h -> h.getResults().stream()).forEach(arg_0 -> ((ProblemsHolder)problemsHolder).registerProblem(arg_0));
    }

    @Override
    @NotNull
    public List<? extends LookupElement> getValueLookups(@NotNull YAMLScalar insertedScalar, @Nullable CompletionContext completionContext) {
        return this.streamSubTypes().flatMap(type -> type.getValueLookups(insertedScalar, completionContext).stream()).collect(Collectors.toList());
    }

    private static List<ProblemsHolder> allProblemsOrEmpty(@NotNull ProblemsHolder problemsHolder, @NotNull List<YamlMetaType> types, @NotNull BiConsumer<YamlMetaType, ProblemsHolder> oneValidation) {
        SmartList problems = new SmartList();
        for (YamlMetaType nextType : types) {
            ProblemsHolder nextHolder = YamlAnyOfType.makeCopy(problemsHolder);
            oneValidation.accept(nextType, nextHolder);
            if (!nextHolder.hasResults()) {
                return Collections.emptyList();
            }
            problems.add(nextHolder);
        }
        return problems;
    }
}

