/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.TypeFieldPair;
import org.jetbrains.yaml.meta.model.YamlArrayType;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Internal
public class Field {
    private static final Pattern PATTERN_ANYTHING = Pattern.compile(".*");
    private final String myName;
    private final MetaTypeSupplier myMetaTypeSupplier;
    private YamlMetaType myMainType;
    private boolean myIsRequired;
    private boolean myEditable = true;
    private boolean myDeprecated = false;
    @Nullable
    private Pattern myNamePattern;
    private boolean myEmptyValueAllowed;
    private boolean myIsMany;
    private Relation myOverriddenDefaultRelation;
    private final Map<Relation, YamlMetaType> myPerRelationTypes = new HashMap<Relation, YamlMetaType>();

    public Field(@NonNls @NotNull String name, @NotNull YamlMetaType mainType) {
        this.myName = name;
        this.myMainType = mainType;
        if (this.myMainType instanceof YamlArrayType) {
            this.myMainType = ((YamlArrayType)this.myMainType).getElementType();
            this.myIsMany = !(this.myMainType instanceof YamlArrayType);
        }
        this.myMetaTypeSupplier = null;
    }

    public Field(@NonNls @NotNull String name, @NotNull MetaTypeSupplier supplier) {
        this.myName = name;
        this.myMetaTypeSupplier = supplier;
    }

    @NotNull
    public Field withDefaultRelation(@NotNull Relation relation) {
        this.myOverriddenDefaultRelation = relation;
        return this;
    }

    public Field withRelationSpecificType(@NotNull Relation relation, @NotNull YamlMetaType specificType) {
        this.myPerRelationTypes.put(relation, specificType);
        return this;
    }

    @NotNull
    public Field withMultiplicityMany() {
        return this.withMultiplicityManyNotOne(true);
    }

    @NotNull
    public Field withMultiplicityManyNotOne(boolean manyNotOne) {
        this.myIsMany = manyNotOne;
        return this;
    }

    @Contract(pure=true)
    public boolean isMany() {
        return this.myIsMany;
    }

    @NotNull
    public Field setRequired() {
        this.myIsRequired = true;
        return this;
    }

    @NotNull
    public Field setDeprecated() {
        this.myDeprecated = true;
        return this;
    }

    @NotNull
    public Field setNonEditable() {
        this.myEditable = false;
        return this;
    }

    @Contract(pure=true)
    public final boolean isRequired() {
        return this.myIsRequired;
    }

    @Contract(pure=true)
    public final boolean isEditable() {
        return this.myEditable;
    }

    @Contract(pure=true)
    public boolean isDeprecated() {
        return this.myDeprecated;
    }

    @Contract(pure=true)
    public final String getName() {
        return this.myName;
    }

    @Contract(pure=true)
    @NotNull
    public YamlMetaType getType(@NotNull Relation relation) {
        return this.myPerRelationTypes.getOrDefault((Object)relation, this.getMainType());
    }

    @Contract(pure=true)
    @NotNull
    public YamlMetaType getDefaultType() {
        return this.getType(this.getDefaultRelation());
    }

    @NotNull
    public Relation getDefaultRelation() {
        if (this.myOverriddenDefaultRelation != null) {
            return this.myOverriddenDefaultRelation;
        }
        if (this.myIsMany || this.getMainType() instanceof YamlArrayType) {
            return Relation.SEQUENCE_ITEM;
        }
        return this.getMainType() instanceof YamlScalarType ? Relation.SCALAR_VALUE : Relation.OBJECT_CONTENTS;
    }

    @NotNull
    public Field withEmptyValueAllowed(boolean allow) {
        this.myEmptyValueAllowed = allow;
        return this;
    }

    @NotNull
    public final Field withAnyName() {
        return this.withAnyName(true);
    }

    @NotNull
    public Field withAnyName(boolean allowAnyName) {
        this.myNamePattern = allowAnyName ? PATTERN_ANYTHING : null;
        return this;
    }

    @NotNull
    public Field withNamePattern(@NotNull Pattern pattern) {
        this.myNamePattern = pattern.pattern().equals(PATTERN_ANYTHING.pattern()) ? PATTERN_ANYTHING : pattern;
        return this;
    }

    public final boolean isAnyNameAllowed() {
        return PATTERN_ANYTHING == this.myNamePattern;
    }

    public final boolean isByPattern() {
        return this.myNamePattern != null;
    }

    public final boolean acceptsFieldName(@NotNull String actualName) {
        if (this.myNamePattern == null) {
            return false;
        }
        if (this.myNamePattern == PATTERN_ANYTHING) {
            return true;
        }
        return this.myNamePattern.matcher(actualName).matches();
    }

    public final boolean isEmptyValueAllowed() {
        return this.myEmptyValueAllowed;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[").append(this.getName()).append("]@");
        result.append(Integer.toHexString(this.hashCode()));
        result.append(" : ");
        result.append(this.getMainType().getTypeName());
        List nonDefaultTypes = this.myPerRelationTypes.entrySet().stream().filter(e -> e.getValue() == this.getMainType()).map(e -> e.getKey() + ":" + e.getValue()).collect(Collectors.toList());
        if (!nonDefaultTypes.isEmpty()) {
            result.append(nonDefaultTypes);
        }
        return result.toString();
    }

    @NotNull
    public List<LookupElementBuilder> getKeyLookups(@NotNull YamlMetaType ownerClass, @NotNull PsiElement insertedScalar) {
        if (this.isByPattern()) {
            return Collections.emptyList();
        }
        LookupElementBuilder lookup = LookupElementBuilder.create((Object)new TypeFieldPair(ownerClass, this), (String)this.getName()).withTypeText(this.getMainType().getDisplayName(), true).withIcon(this.getLookupIcon()).withStrikeoutness(this.isDeprecated());
        if (this.isRequired()) {
            lookup = lookup.bold();
        }
        return Collections.singletonList(lookup);
    }

    @Nullable
    public PsiReference getReferenceFromKey(@NotNull YAMLKeyValue keyValue) {
        return null;
    }

    public boolean hasRelationSpecificType(@NotNull Relation relation) {
        return relation == this.getDefaultRelation() || this.myPerRelationTypes.containsKey((Object)relation);
    }

    @Nullable
    public Icon getLookupIcon() {
        return this.myIsMany ? AllIcons.Json.Array : this.getMainType().getIcon();
    }

    @NotNull
    public Field resolveToSpecializedField(@NotNull YAMLValue element) {
        if (this.myMetaTypeSupplier == null) {
            return this;
        }
        YamlMetaType specializedType = this.myMetaTypeSupplier.getSpecializedType(element);
        if (specializedType == null) {
            return this;
        }
        return this.cloneWithNewType(specializedType);
    }

    private Field cloneWithNewType(@NotNull YamlMetaType newType) {
        Field result = this.newField(newType);
        result.myIsRequired = this.myIsRequired;
        result.myEditable = this.myEditable;
        result.myDeprecated = this.myDeprecated;
        result.myNamePattern = this.myNamePattern;
        result.myEmptyValueAllowed = this.myEmptyValueAllowed;
        result.myIsMany = this.myIsMany;
        result.myOverriddenDefaultRelation = this.myOverriddenDefaultRelation;
        result.myPerRelationTypes.putAll(this.myPerRelationTypes);
        return result;
    }

    @NotNull
    protected Field newField(@NotNull YamlMetaType type) {
        return new Field(this.myName, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private YamlMetaType getMainType() {
        if (this.myMainType != null) {
            return this.myMainType;
        }
        assert (this.myMetaTypeSupplier != null);
        MetaTypeSupplier metaTypeSupplier = this.myMetaTypeSupplier;
        synchronized (metaTypeSupplier) {
            if (this.myMainType == null) {
                try {
                    YamlMetaType mainType = this.myMetaTypeSupplier.getMainType();
                    assert (!(this.myMainType instanceof YamlArrayType)) : "Type supplier must not provide array types";
                    this.myMainType = mainType;
                }
                catch (Exception e) {
                    throw new RuntimeException("Supplier failed to return a metatype for field: " + this, e);
                }
            }
            return this.myMainType;
        }
    }

    public static interface MetaTypeSupplier {
        @NotNull
        public YamlMetaType getMainType();

        @Nullable
        default public YamlMetaType getSpecializedType(@NotNull YAMLValue element) {
            return null;
        }
    }

    public static enum Relation {
        SCALAR_VALUE,
        SEQUENCE_ITEM,
        OBJECT_CONTENTS;

    }
}

