/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;

public final class YAMLUnusedAnchorInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new YamlPsiElementVisitor(){

            @Override
            public void visitAnchor(@NotNull YAMLAnchor anchor) {
                Collection references = ReferencesSearch.search((PsiElement)anchor, (SearchScope)GlobalSearchScope.fileScope((PsiFile)anchor.getContainingFile())).findAll();
                if (references.isEmpty()) {
                    holder.registerProblem((PsiElement)anchor, YAMLBundle.message("inspections.unused.anchor.message", anchor.getName()), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveAnchorQuickFix(anchor)});
                }
            }
        };
    }

    private static class RemoveAnchorQuickFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<YAMLAnchor> myAnchorHolder;

        RemoveAnchorQuickFix(@NotNull YAMLAnchor anchor) {
            this.myAnchorHolder = SmartPointerManager.getInstance((Project)anchor.getProject()).createSmartPsiElementPointer((PsiElement)anchor);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return YAMLBundle.message("inspections.unused.anchor.quickfix.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            YAMLAnchor anchor = (YAMLAnchor)this.myAnchorHolder.getElement();
            if (anchor == null) {
                return;
            }
            PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> {
                ASTNode node = TreeUtil.prevLeaf((ASTNode)anchor.getNode());
                while (YAMLElementTypes.SPACE_ELEMENTS.contains(PsiUtilCore.getElementType((ASTNode)node))) {
                    assert (node != null);
                    ASTNode prev = TreeUtil.prevLeaf((ASTNode)node);
                    ASTNode parent = node.getTreeParent();
                    if (parent != null) {
                        CodeEditUtil.removeChild((ASTNode)parent, (ASTNode)node);
                    }
                    node = prev;
                }
                anchor.delete();
            });
        }
    }
}

