/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.FactoryMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import kotlin.text.StringsKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.formatter.YAMLCodeStyleSettings;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

class YAMLFormattingContext {
    private static final Indent DIRECT_NORMAL_INDENT = Indent.getNormalIndent((boolean)true);
    private static final Indent SAME_AS_PARENT_INDENT = Indent.getSpaceIndent((int)0, (boolean)true);
    private static final Indent SAME_AS_INDENTED_ANCESTOR_INDENT = Indent.getSpaceIndent((int)0);
    @NotNull
    public final CodeStyleSettings mySettings;
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final SpacingBuilder mySpaceBuilder;
    @NotNull
    private final Map<ASTNode, Alignment> myChildIndentAlignments = FactoryMap.create(node -> Alignment.createAlignment((boolean)true));
    @NotNull
    private final Map<ASTNode, Alignment> myChildValueAlignments = FactoryMap.create(node -> Alignment.createAlignment((boolean)true));
    private final boolean shouldIndentSequenceValue;
    private final boolean shouldInlineSequenceIntoSequence;
    private final boolean shouldInlineBlockMappingIntoSequence;
    private final int getValueAlignment;
    @Nullable
    private String myFullText = null;
    private static final TokenSet NON_SIGNIFICANT_TOKENS_BEFORE_TEMPLATE = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE, YAMLTokenTypes.SEQUENCE_MARKER});

    YAMLFormattingContext(@NotNull CodeStyleSettings settings, @NotNull PsiFile file) {
        this.mySettings = settings;
        this.myFile = file;
        YAMLCodeStyleSettings custom = (YAMLCodeStyleSettings)this.mySettings.getCustomSettings(YAMLCodeStyleSettings.class);
        CommonCodeStyleSettings common = this.mySettings.getCommonSettings((Language)YAMLLanguage.INSTANCE);
        this.mySpaceBuilder = new SpacingBuilder(this.mySettings, (Language)YAMLLanguage.INSTANCE).between((IElementType)YAMLTokenTypes.COLON, (IElementType)YAMLElementTypes.KEY_VALUE_PAIR).lineBreakInCode().between((IElementType)YAMLTokenTypes.COLON, (IElementType)YAMLElementTypes.SEQUENCE_ITEM).lineBreakInCode().between((IElementType)YAMLElementTypes.ALIAS_NODE, (IElementType)YAMLTokenTypes.COLON).spaces(1).before((IElementType)YAMLTokenTypes.COLON).spaceIf(custom.SPACE_BEFORE_COLON).after((IElementType)YAMLTokenTypes.COLON).spaces(1).after((IElementType)YAMLTokenTypes.LBRACKET).spaceIf(common.SPACE_WITHIN_BRACKETS).before((IElementType)YAMLTokenTypes.RBRACKET).spaceIf(common.SPACE_WITHIN_BRACKETS).after((IElementType)YAMLTokenTypes.LBRACE).spaceIf(common.SPACE_WITHIN_BRACES).before((IElementType)YAMLTokenTypes.RBRACE).spaceIf(common.SPACE_WITHIN_BRACES);
        this.shouldIndentSequenceValue = custom.INDENT_SEQUENCE_VALUE;
        this.shouldInlineSequenceIntoSequence = !custom.SEQUENCE_ON_NEW_LINE;
        this.shouldInlineBlockMappingIntoSequence = !custom.BLOCK_MAPPING_ON_NEW_LINE;
        this.getValueAlignment = custom.ALIGN_VALUES_PROPERTIES;
    }

    private static boolean isAfterKey(ASTNode node) {
        List nodes = ((StreamEx)((StreamEx)((StreamEx)StreamEx.iterate((Object)node, Objects::nonNull, TreeUtil::prevLeaf).skip(1L)).dropWhile(n -> NON_SIGNIFICANT_TOKENS_BEFORE_TEMPLATE.contains(n.getElementType()))).limit(2L)).toList();
        if (nodes.size() != 2) {
            return false;
        }
        return ((Object)((Object)YAMLTokenTypes.COLON)).equals(((ASTNode)nodes.get(0)).getElementType()) && ((Object)((Object)YAMLTokenTypes.SCALAR_KEY)).equals(((ASTNode)nodes.get(1)).getElementType());
    }

    private static boolean isAfterSequenceMarker(ASTNode node) {
        List nodes = ((StreamEx)((StreamEx)((StreamEx)((StreamEx)StreamEx.iterate((Object)node, Objects::nonNull, n -> n.getTreePrev()).skip(1L)).filter(n -> !YAMLElementTypes.SPACE_ELEMENTS.contains(n.getElementType()))).takeWhile(n -> !((Object)((Object)YAMLTokenTypes.EOL)).equals(n.getElementType()))).limit(2L)).toList();
        if (nodes.size() != 1) {
            return false;
        }
        return ((Object)((Object)YAMLTokenTypes.SEQUENCE_MARKER)).equals(((ASTNode)nodes.get(0)).getElementType());
    }

    private static boolean isAdjectiveToMinus(ASTNode node) {
        ASTNode prevLeaf = TreeUtil.prevLeaf((ASTNode)node);
        return prevLeaf != null && ((Object)((Object)YAMLTokenTypes.SEQUENCE_MARKER)).equals(prevLeaf.getElementType());
    }

    @Nullable
    Spacing computeSpacing(@NotNull Block parent, @Nullable Block child1, @NotNull Block child2) {
        if (child1 instanceof ASTBlock && YAMLFormattingContext.endsWithTemplate(((ASTBlock)child1).getNode())) {
            return null;
        }
        if (child2 instanceof ASTBlock && YAMLFormattingContext.startsWithTemplate(((ASTBlock)child2).getNode())) {
            ASTNode astNode = ((ASTBlock)child2).getNode();
            if (!YAMLFormattingContext.isAdjectiveToMinus(astNode)) {
                if (YAMLFormattingContext.isAfterKey(astNode)) {
                    return this.mySpaceBuilder.getSpacing(parent, YAMLFormattingContext.getNodeElementType(parent), (IElementType)YAMLTokenTypes.COLON, (IElementType)YAMLTokenTypes.SCALAR_TEXT);
                }
                if (YAMLFormattingContext.isAfterSequenceMarker(astNode)) {
                    return this.getSpacingAfterSequenceMarker(child1, child2);
                }
            }
            return null;
        }
        Spacing simpleSpacing = this.mySpaceBuilder.getSpacing(parent, child1, child2);
        if (simpleSpacing != null) {
            return simpleSpacing;
        }
        return this.getSpacingAfterSequenceMarker(child1, child2);
    }

    private Spacing getSpacingAfterSequenceMarker(Block child1, Block child2) {
        if (!(child1 instanceof ASTBlock) || !(child2 instanceof ASTBlock)) {
            return null;
        }
        ASTNode node1 = ((ASTBlock)child1).getNode();
        ASTNode node2 = ((ASTBlock)child2).getNode();
        if (PsiUtilCore.getElementType((ASTNode)node1) != YAMLTokenTypes.SEQUENCE_MARKER) {
            return null;
        }
        IElementType node2Type = PsiUtilCore.getElementType((ASTNode)node2);
        int indentSize = this.mySettings.getIndentSize((FileType)YAMLFileType.YML);
        if (indentSize < 2) {
            indentSize = 2;
        }
        int spaces = 1;
        int minLineFeeds = 0;
        if (node2Type == YAMLElementTypes.SEQUENCE_ITEM) {
            if (this.shouldInlineSequenceIntoSequence) {
                spaces = indentSize - 1;
            } else {
                minLineFeeds = 1;
            }
        } else if (node2Type == YAMLElementTypes.KEY_VALUE_PAIR) {
            if (this.shouldInlineBlockMappingIntoSequence) {
                spaces = indentSize - 1;
            } else {
                minLineFeeds = 1;
            }
        }
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)minLineFeeds, (boolean)false, (int)0);
    }

    @Nullable
    private static IElementType getNodeElementType(Block parent) {
        if (parent == null) {
            return null;
        }
        ASTBlock it = (ASTBlock)ObjectUtils.tryCast((Object)parent, ASTBlock.class);
        if (it == null) {
            return null;
        }
        ASTNode node = it.getNode();
        if (node == null) {
            return null;
        }
        return node.getElementType();
    }

    private static boolean startsWithTemplate(@Nullable ASTNode astNode) {
        while (astNode != null) {
            if (astNode instanceof OuterLanguageElement) {
                return true;
            }
            if (NON_SIGNIFICANT_TOKENS_BEFORE_TEMPLATE.contains(astNode.getElementType())) {
                astNode = astNode.getTreeNext();
                continue;
            }
            astNode = astNode.getFirstChildNode();
        }
        return false;
    }

    private static boolean endsWithTemplate(@Nullable ASTNode astNode) {
        while (astNode != null) {
            if (astNode instanceof OuterLanguageElement) {
                return true;
            }
            astNode = astNode.getLastChildNode();
        }
        return false;
    }

    @Nullable
    Alignment computeAlignment(@NotNull ASTNode node) {
        ASTNode prev;
        IElementType type = PsiUtilCore.getElementType((ASTNode)node);
        if (type == YAMLElementTypes.SEQUENCE_ITEM) {
            if (node.getTreeParent().getElementType() == YAMLElementTypes.ARRAY) {
                YAMLSequence sequence = (YAMLSequence)node.getTreeParent().getPsi();
                for (YAMLSequenceItem child : sequence.getItems()) {
                    if (!child.textContains('\n')) continue;
                    return null;
                }
            }
            return this.myChildIndentAlignments.get(node.getTreeParent());
        }
        if (type == YAMLElementTypes.KEY_VALUE_PAIR) {
            return this.myChildIndentAlignments.get(node.getTreeParent());
        }
        if (this.getValueAlignment == 2) {
            if (type == YAMLTokenTypes.COLON) {
                return this.myChildValueAlignments.get(node.getTreeParent().getTreeParent());
            }
        } else if (this.getValueAlignment == 1 && YAMLElementTypes.SCALAR_ITEMS.contains(type) && PsiUtilCore.getElementType((ASTNode)(prev = YAMLFormattingContext.getPreviousNonBlankNode(node.getTreeParent()))) == YAMLTokenTypes.COLON) {
            return this.myChildValueAlignments.get(prev.getTreeParent().getTreeParent());
        }
        return null;
    }

    @Nullable
    Indent computeBlockIndent(@NotNull ASTNode node) {
        IElementType grand2ParentType;
        Indent templateIndent;
        if (node instanceof OuterLanguageElement && (templateIndent = this.computeTemplateIndent(((OuterLanguageElement)node).getTextRange())) != null) {
            return templateIndent;
        }
        IElementType nodeType = PsiUtilCore.getElementType((ASTNode)node);
        IElementType parentType = PsiUtilCore.getElementType((ASTNode)node.getTreeParent());
        IElementType grandParentType = parentType == null ? null : PsiUtilCore.getElementType((ASTNode)node.getTreeParent().getTreeParent());
        IElementType iElementType = grand2ParentType = grandParentType == null ? null : PsiUtilCore.getElementType((ASTNode)node.getTreeParent().getTreeParent().getTreeParent());
        assert (nodeType != YAMLElementTypes.SEQUENCE) : "Sequence should be inlined!";
        assert (nodeType != YAMLElementTypes.MAPPING) : "Mapping should be inlined!";
        assert (nodeType != YAMLElementTypes.DOCUMENT) : "Document should be inlined!";
        if (YAMLElementTypes.DOCUMENT_BRACKETS.contains(nodeType)) {
            return SAME_AS_PARENT_INDENT;
        }
        if (YAMLElementTypes.BRACKETS.contains(nodeType)) {
            return SAME_AS_INDENTED_ANCESTOR_INDENT;
        }
        if (YAMLElementTypes.TEXT_SCALAR_ITEMS.contains(nodeType)) {
            if (grandParentType == YAMLElementTypes.DOCUMENT) {
                return SAME_AS_PARENT_INDENT;
            }
            if (grand2ParentType == YAMLElementTypes.ARRAY || grand2ParentType == YAMLElementTypes.HASH) {
                return Indent.getContinuationWithoutFirstIndent();
            }
            return DIRECT_NORMAL_INDENT;
        }
        if (nodeType == YAMLElementTypes.FILE) {
            return SAME_AS_PARENT_INDENT;
        }
        if (YAMLElementTypes.SCALAR_VALUES.contains(nodeType)) {
            return DIRECT_NORMAL_INDENT;
        }
        if (nodeType == YAMLElementTypes.SEQUENCE_ITEM) {
            return this.computeSequenceItemIndent(node);
        }
        if (nodeType == YAMLElementTypes.KEY_VALUE_PAIR) {
            return YAMLFormattingContext.computeKeyValuePairIndent(node);
        }
        if (nodeType == YAMLTokenTypes.COMMENT) {
            if (parentType == YAMLElementTypes.SEQUENCE) {
                return this.computeSequenceItemIndent(node);
            }
            if (parentType == YAMLElementTypes.MAPPING) {
                return YAMLFormattingContext.computeKeyValuePairIndent(node);
            }
        }
        return YAMLElementTypes.TOP_LEVEL.contains(parentType) ? SAME_AS_PARENT_INDENT : null;
    }

    @Nullable
    private Indent computeTemplateIndent(TextRange nodeTextRange) {
        Document document = PsiDocumentManager.getInstance((Project)this.myFile.getProject()).getDocument(this.myFile);
        if (document == null) {
            return null;
        }
        int lineNumber = document.getLineNumber(nodeTextRange.getStartOffset());
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        if (!StringsKt.isBlank((CharSequence)document.getCharsSequence().subSequence(lineStartOffset, nodeTextRange.getStartOffset()))) {
            return null;
        }
        return new IndentImpl(Indent.Type.SPACES, true, nodeTextRange.getStartOffset() - lineStartOffset, false, false);
    }

    @Nullable
    Indent computeNewChildIndent(@NotNull ASTNode node) {
        return YAMLElementTypes.TOP_LEVEL.contains(PsiUtilCore.getElementType((ASTNode)node)) ? SAME_AS_PARENT_INDENT : DIRECT_NORMAL_INDENT;
    }

    public boolean isIncomplete(@NotNull ASTNode node) {
        YAMLValue value2;
        Predicate<YAMLValue> possiblyIncompleteValue = value -> value == null || YAMLElementTypes.INCOMPLETE_BLOCKS.contains(PsiUtilCore.getElementType((PsiElement)value));
        if (PsiUtilCore.getElementType((ASTNode)node) == YAMLElementTypes.KEY_VALUE_PAIR ? possiblyIncompleteValue.test(value2 = ((YAMLKeyValue)node.getPsi()).getValue()) : PsiUtilCore.getElementType((ASTNode)node) == YAMLElementTypes.SEQUENCE_ITEM && possiblyIncompleteValue.test(value = ((YAMLSequenceItem)node.getPsi()).getValue())) {
            return true;
        }
        return FormatterUtil.isIncomplete((ASTNode)node);
    }

    @NotNull
    public String getFullText() {
        if (this.myFullText == null) {
            this.myFullText = this.myFile.getText();
        }
        return this.myFullText;
    }

    @Nullable
    private static Indent computeKeyValuePairIndent(@NotNull ASTNode node) {
        boolean grandParentIsDocument;
        IElementType parentType = PsiUtilCore.getElementType((ASTNode)node.getTreeParent());
        IElementType grandParentType = parentType == null ? null : PsiUtilCore.getElementType((ASTNode)node.getTreeParent().getTreeParent());
        boolean bl = grandParentIsDocument = grandParentType == YAMLElementTypes.DOCUMENT;
        if (parentType == YAMLElementTypes.HASH) {
            return Indent.getNormalIndent();
        }
        if (grandParentIsDocument) {
            return SAME_AS_PARENT_INDENT;
        }
        if (parentType == YAMLElementTypes.SEQUENCE_ITEM) {
            return Indent.getNoneIndent();
        }
        return DIRECT_NORMAL_INDENT;
    }

    @NotNull
    private Indent computeSequenceItemIndent(@NotNull ASTNode node) {
        boolean grandParentIsDocument;
        IElementType parentType = PsiUtilCore.getElementType((ASTNode)node.getTreeParent());
        IElementType grandParentType = parentType == null ? null : PsiUtilCore.getElementType((ASTNode)node.getTreeParent().getTreeParent());
        boolean bl = grandParentIsDocument = grandParentType == YAMLElementTypes.DOCUMENT;
        if (parentType == YAMLElementTypes.ARRAY) {
            return Indent.getNormalIndent();
        }
        if (grandParentType == YAMLElementTypes.KEY_VALUE_PAIR) {
            if (this.shouldIndentSequenceValue) {
                return DIRECT_NORMAL_INDENT;
            }
            return SAME_AS_PARENT_INDENT;
        }
        if (grandParentIsDocument) {
            return SAME_AS_PARENT_INDENT;
        }
        return DIRECT_NORMAL_INDENT;
    }

    @Nullable
    private static ASTNode getPreviousNonBlankNode(ASTNode node) {
        do {
            if (YAMLElementTypes.BLANK_ELEMENTS.contains(PsiUtilCore.getElementType((ASTNode)(node = TreeUtil.prevLeaf((ASTNode)node))))) continue;
            return node;
        } while (node != null);
        return null;
    }
}

