/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class YAMLTextUtil {
    private YAMLTextUtil() {
    }

    public static int getLineStartSafeOffset(@NotNull Document document, int line) {
        if (line >= document.getLineCount()) {
            return document.getTextLength();
        }
        if (line < 0) {
            return 0;
        }
        return document.getLineStartOffset(line);
    }

    public static int getStartIndentSize(@NotNull CharSequence text) {
        char c;
        int stop;
        for (stop = 0; stop < text.length() && ((c = text.charAt(stop)) == ' ' || c == '\t'); ++stop) {
        }
        return stop;
    }

    @NotNull
    public static String indentText(@NotNull String text, int indent) {
        StringBuilder buffer = new StringBuilder();
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indent);
        buffer.append(indentString);
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            buffer.append(c);
            if (c != '\n') continue;
            buffer.append(indentString);
        }
        return buffer.toString();
    }
}

