/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Iterator;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.javac.JpsFileObject;
import org.jetbrains.jps.javac.JpsJavacFileManager;

public final class OutputFileObject
extends JpsFileObject {
    @Nullable
    private final JpsJavacFileManager.Context myContext;
    @Nullable
    private final File myOutputRoot;
    private final String myRelativePath;
    private final File myFile;
    @Nullable
    private final String myClassName;
    private final Iterable<URI> mySources;
    private volatile BinaryContent myContent;
    private final String myEncodingName;
    private final boolean myIsGenerated;

    public OutputFileObject(@Nullable JpsJavacFileManager.Context context, @Nullable File outputRoot, String relativePath, @NotNull File file, @NotNull JavaFileObject.Kind kind, @Nullable String className, @NotNull Iterable<URI> sources, @Nullable String encodingName, @Nullable BinaryContent content, JavaFileManager.Location location, boolean isFromGeneratedSource) {
        super(FileUtilRt.fileToUri((File)file), kind, location);
        this.myContext = context;
        this.mySources = sources;
        this.myContent = content;
        this.myOutputRoot = outputRoot;
        this.myRelativePath = relativePath;
        this.myFile = file;
        this.myClassName = className != null ? className.replace('/', '.') : null;
        this.myEncodingName = encodingName;
        this.myIsGenerated = isFromGeneratedSource;
    }

    @Nullable
    public File getOutputRoot() {
        return this.myOutputRoot;
    }

    public String getRelativePath() {
        return this.myRelativePath;
    }

    @NotNull
    public File getFile() {
        return this.myFile;
    }

    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    public boolean isGenerated() {
        return this.myIsGenerated;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public File getSourceFile() {
        Iterator<File> it = this.getSourceFiles().iterator();
        return it.hasNext() ? it.next() : null;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public Iterable<File> getSourceFiles() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    public Iterable<URI> getSourceUris() {
        return this.mySources;
    }

    @Override
    @Nullable
    protected String inferBinaryName(Iterable<? extends File> path, boolean caseSensitiveFS) {
        return null;
    }

    @Override
    public ByteArrayOutputStream openOutputStream() {
        return new ByteArrayOutputStream(){
            private boolean isClosed = false;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private synchronized boolean markClosed() {
                if (this.isClosed) return false;
                this.isClosed = true;
                if (!true) return false;
                return true;
            }

            @Override
            public void close() throws IOException {
                if (this.markClosed()) {
                    try {
                        super.close();
                    }
                    finally {
                        OutputFileObject.this.myContent = new BinaryContent(this.buf, 0, this.size());
                        if (OutputFileObject.this.myContext != null) {
                            OutputFileObject.this.myContext.consumeOutputFile(OutputFileObject.this);
                        }
                    }
                }
            }
        };
    }

    @Override
    public InputStream openInputStream() throws IOException {
        BinaryContent bytes = this.myContent;
        if (bytes != null) {
            return new ByteArrayInputStream(bytes.getBuffer(), bytes.getOffset(), bytes.getLength());
        }
        return new BufferedInputStream(new FileInputStream(this.myFile));
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        BinaryContent content = this.myContent;
        String encoding = this.myEncodingName;
        if (content != null) {
            return encoding == null ? new String(content.getBuffer(), content.getOffset(), content.getLength()) : new String(content.getBuffer(), content.getOffset(), content.getLength(), encoding);
        }
        return OutputFileObject.loadCharContent(this.myFile, encoding);
    }

    @Override
    public Writer openWriter() throws IOException {
        String encoding = this.myEncodingName;
        return encoding != null ? new OutputStreamWriter((OutputStream)this.openOutputStream(), encoding) : super.openWriter();
    }

    @Nullable
    public BinaryContent getContent() {
        return this.myContent;
    }

    public void updateContent(@NotNull byte[] updatedContent) {
        this.myContent = new BinaryContent(updatedContent, 0, updatedContent.length);
    }
}

