/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.javac.JpsFileObject;
import org.jetbrains.jps.javac.ValueSupplier;

public final class InputFileObject
extends JpsFileObject {
    private final File myFile;
    private final String myEncoding;
    private final ValueSupplier<File, RuntimeException> myAbsFile;
    private final ValueSupplier<CharSequence, IOException> myContent;

    InputFileObject(File f, String encoding, boolean canCacheContent) {
        super(FileUtilRt.fileToUri((File)f), InputFileObject.findKind(f.getName()), StandardLocation.SOURCE_PATH);
        this.myFile = f;
        this.myEncoding = encoding;
        this.myAbsFile = ValueSupplier.asCaching(new ValueSupplier<File, RuntimeException>(){

            @Override
            public File get() {
                return InputFileObject.this.myFile.getAbsoluteFile();
            }
        });
        ValueSupplier<CharSequence, IOException> contentProvider = new ValueSupplier<CharSequence, IOException>(){

            @Override
            public CharSequence get() throws IOException {
                return JpsFileObject.loadCharContent(InputFileObject.this.myFile, InputFileObject.this.myEncoding);
            }
        };
        this.myContent = canCacheContent ? ValueSupplier.asCaching(contentProvider) : contentProvider;
    }

    public File getFile() {
        return this.myFile;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.myFile));
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLastModified() {
        return this.myFile.lastModified();
    }

    @Override
    public boolean delete() {
        return this.myFile.delete();
    }

    @Override
    protected String inferBinaryName(Iterable<? extends File> path, boolean caseSensitiveFS) {
        String fPath = this.myFile.getPath();
        for (File file : path) {
            int separatorIdx;
            String dirPath = file.getPath();
            if (dirPath.length() == 0) {
                dirPath = System.getProperty("user.dir");
            }
            if (!fPath.regionMatches(!caseSensitiveFS, 0, dirPath, 0, dirPath.length())) continue;
            int pathLength = fPath.length();
            boolean endsWithSeparator = dirPath.endsWith(File.separator);
            if (!endsWithSeparator && (pathLength <= (separatorIdx = dirPath.length()) || fPath.charAt(separatorIdx) != File.separatorChar)) continue;
            int startIndex = endsWithSeparator ? dirPath.length() : dirPath.length() + 1;
            int endIndex = fPath.lastIndexOf(46);
            if (endIndex <= startIndex) {
                endIndex = fPath.length();
            }
            int length = endIndex - startIndex;
            StringBuilder buf = new StringBuilder(length).append(fPath, startIndex, endIndex);
            for (int idx = 0; idx < length; ++idx) {
                if (buf.charAt(idx) != File.separatorChar) continue;
                buf.setCharAt(idx, '.');
            }
            return buf.toString();
        }
        return null;
    }

    @Override
    public boolean isNameCompatible(@NotNull String cn, JavaFileObject.Kind kind) {
        if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
            return false;
        }
        String n = cn + kind.extension;
        String name = this.myFile.getName();
        if (name.equals(n)) {
            return true;
        }
        if (name.equalsIgnoreCase(n)) {
            try {
                return n.equals(this.myFile.getCanonicalFile().getName());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InputFileObject)) {
            return false;
        }
        InputFileObject o = (InputFileObject)other;
        return this.getAbsoluteFile().equals(o.getAbsoluteFile());
    }

    @Override
    public int hashCode() {
        return this.getAbsoluteFile().hashCode();
    }

    private File getAbsoluteFile() {
        return this.myAbsFile.get();
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return this.myContent.get();
    }
}

