/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Function;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.javac.FileObjectKindFilter;
import org.jetbrains.jps.javac.FileOperations;
import org.jetbrains.jps.javac.Iterators;
import org.jetbrains.jps.javac.ZipFileObject;

final class DefaultFileOperations
implements FileOperations {
    private static final Iterable<File> NULL_ITERABLE = new Iterable<File>(){

        @Override
        @NotNull
        public Iterator<File> iterator() {
            return Collections.emptyList().iterator();
        }

        public String toString() {
            return "NULL_ITERABLE";
        }
    };
    private static final FileOperations.Archive NULL_ARCHIVE = new FileOperations.Archive(){

        @Override
        @NotNull
        public Iterable<JavaFileObject> list(String relPath, Set<JavaFileObject.Kind> kinds, boolean recurse) {
            return Collections.emptyList();
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "NULL_ARCHIVE";
        }
    };
    private final Map<File, Iterable<File>> myDirectoryCache = new HashMap<File, Iterable<File>>();
    private final Map<File, FileOperations.Archive> myArchiveCache = new HashMap<File, FileOperations.Archive>();
    private final Map<File, Boolean> myIsFile = new HashMap<File, Boolean>();

    DefaultFileOperations() {
    }

    @Override
    @NotNull
    public Iterable<File> listFiles(final File file, boolean recursively) {
        Iterable<File> childrenIterable = Iterators.lazy(new Iterators.Provider<Iterable<File>>(){

            @Override
            public Iterable<File> get() {
                Iterable children = DefaultFileOperations.this.listChildren(file);
                return children == null ? Collections.emptyList() : children;
            }
        });
        return !recursively ? childrenIterable : Iterators.flat(Iterators.map(childrenIterable, new Function<File, Iterable<File>>(){

            public Iterable<File> fun(File ff) {
                return DefaultFileOperations.this.asRecursiveIterable(ff);
            }
        }));
    }

    private Iterable<File> asRecursiveIterable(File file) {
        return Iterators.flat(Iterators.map(Iterators.asIterable(file), new Function<File, Iterable<File>>(){

            public Iterable<File> fun(File f) {
                Iterable children = DefaultFileOperations.this.listChildren(f);
                if (children == null) {
                    return Iterators.asIterable(f);
                }
                if (Iterators.isEmptyCollection(children)) {
                    return children;
                }
                return Iterators.flat(Iterators.map(children, new Function<File, Iterable<File>>(){

                    public Iterable<File> fun(File ff) {
                        return DefaultFileOperations.this.asRecursiveIterable(ff);
                    }
                }));
            }
        }));
    }

    @Override
    public boolean isFile(File file) {
        Boolean cachedIsFile = this.myIsFile.get(file);
        if (cachedIsFile == null) {
            cachedIsFile = file.isFile();
            this.myIsFile.put(file, cachedIsFile);
        }
        return cachedIsFile;
    }

    @Override
    public void clearCaches(@Nullable File file) {
        if (file != null) {
            this.myDirectoryCache.clear();
            FileOperations.Archive arch = this.myArchiveCache.remove(file);
            if (arch != null) {
                try {
                    arch.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            this.myDirectoryCache.clear();
            this.myIsFile.clear();
            Map<File, FileOperations.Archive> archCache = this.myArchiveCache;
            for (Map.Entry<File, FileOperations.Archive> entry : archCache.entrySet()) {
                try {
                    entry.getValue().close();
                }
                catch (Throwable throwable) {}
            }
            archCache.clear();
        }
    }

    @Override
    @Nullable
    public FileOperations.Archive lookupArchive(File file) {
        FileOperations.Archive arch = this.myArchiveCache.get(file);
        return arch == NULL_ARCHIVE ? null : arch;
    }

    @Override
    public FileOperations.Archive openArchive(File root, String contentEncoding, @NotNull JavaFileManager.Location location) throws IOException {
        FileOperations.Archive arch = this.myArchiveCache.get(root);
        if (arch != null) {
            return arch == NULL_ARCHIVE ? null : arch;
        }
        try {
            arch = new ZipArchive(root, contentEncoding, location);
            this.myArchiveCache.put(root, arch);
            return arch;
        }
        catch (IOException e) {
            if (this.isJarOrZip(root)) {
                throw e;
            }
            this.myArchiveCache.put(root, NULL_ARCHIVE);
            return null;
        }
    }

    private boolean isJarOrZip(File root) {
        if (!this.isFile(root)) {
            return false;
        }
        String name = root.getName();
        return StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)".jar") || StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)".zip");
    }

    @Nullable
    private Iterable<File> listChildren(File file) {
        Iterable<File> cached = this.myDirectoryCache.get(file);
        if (cached == null) {
            Iterable<File> parentFiles = this.lookupCachedParent(file);
            if (parentFiles == null || parentFiles != NULL_ITERABLE && !Iterators.isEmptyCollection(parentFiles)) {
                try {
                    cached = DefaultFileOperations.listFiles(file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.myDirectoryCache.put(file, cached == null ? NULL_ITERABLE : cached);
        }
        return cached == NULL_ITERABLE ? null : cached;
    }

    private Iterable<File> lookupCachedParent(File file) {
        if (!this.myDirectoryCache.isEmpty()) {
            File parent = file.getParentFile();
            for (int i = 0; i < 10 && parent != null; parent = parent.getParentFile(), ++i) {
                Iterable<File> cached = this.myDirectoryCache.get(parent);
                if (cached == null) continue;
                return cached;
            }
        }
        return null;
    }

    @Nullable
    private static Iterable<File> listFiles(File file) throws IOException {
        File[] files = file.listFiles();
        return files != null ? Arrays.asList(files) : null;
    }

    private static class ZipArchive
    implements FileOperations.Archive {
        private final ZipFile myZip;
        private final Map<String, Collection<ZipEntry>> myPaths = new HashMap<String, Collection<ZipEntry>>();
        private final Function<ZipEntry, JavaFileObject> myToFileObjectConverter;
        private static final FileObjectKindFilter<ZipEntry> ourEntryFilter = new FileObjectKindFilter<ZipEntry>(new Function<ZipEntry, String>(){

            public String fun(ZipEntry zipEntry) {
                return zipEntry.getName();
            }
        });

        ZipArchive(final File root, final String encodingName, final JavaFileManager.Location location) throws IOException {
            this.myZip = new ZipFile(root, 1);
            Enumeration<? extends ZipEntry> entries = this.myZip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String parent = ZipArchive.getParentPath(entry.getName());
                Collection<ZipEntry> children = this.myPaths.get(parent);
                if (children == null) {
                    children = new ArrayList<ZipEntry>();
                    this.myPaths.put(parent, children);
                }
                children.add(entry);
            }
            this.myToFileObjectConverter = new Function<ZipEntry, JavaFileObject>(){

                public JavaFileObject fun(ZipEntry zipEntry) {
                    return new ZipFileObject(root, ZipArchive.this.myZip, zipEntry, encodingName, location);
                }
            };
        }

        @Override
        @NotNull
        public Iterable<JavaFileObject> list(final String relPath, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            Collection<ZipEntry> entries = this.myPaths.get(relPath);
            if (entries == null || entries.isEmpty()) {
                return Collections.emptyList();
            }
            Iterable<ZipEntry> entriesIterable = entries;
            if (recurse) {
                if (relPath.isEmpty()) {
                    entriesIterable = Iterators.flat(this.myPaths.values());
                } else {
                    Iterable<Map.Entry<String, Collection<ZipEntry>>> baseIterable = Iterators.filter(this.myPaths.entrySet(), new BooleanFunction<Map.Entry<String, Collection<ZipEntry>>>(){

                        public boolean fun(Map.Entry<String, Collection<ZipEntry>> e) {
                            String dir = e.getKey();
                            return dir.startsWith(relPath) && (dir.length() == relPath.length() || dir.charAt(relPath.length()) == '/');
                        }
                    });
                    entriesIterable = Iterators.flat(Iterators.map(baseIterable, new Function<Map.Entry<String, Collection<ZipEntry>>, Iterable<ZipEntry>>(){

                        public Iterable<ZipEntry> fun(Map.Entry<String, Collection<ZipEntry>> e) {
                            return e.getValue();
                        }
                    }));
                }
            }
            return Iterators.map(Iterators.filter(entriesIterable, ourEntryFilter.getFor(kinds)), this.myToFileObjectConverter);
        }

        @Override
        public void close() throws IOException {
            this.myPaths.clear();
            this.myZip.close();
        }

        private static String getParentPath(String path) {
            int idx = path.lastIndexOf(47);
            if (idx == path.length() - 1) {
                idx = path.lastIndexOf(47, idx - 1);
            }
            if (idx < 0) {
                return "";
            }
            return path.substring(0, idx);
        }
    }
}

