/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl.java;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.CannotCreateJavaCompilerException;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.javac.JavacMain;

public final class JavacCompilerTool
extends JavaCompilingTool {
    public static final String ID = "Javac";
    public static final String ALTERNATIVE_ID = "compAPI";

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @Nullable
    public String getAlternativeId() {
        return ALTERNATIVE_ID;
    }

    @Override
    public boolean isCompilerTreeAPISupported() {
        return true;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "javac " + System.getProperty("java.version");
    }

    @Override
    @NotNull
    public JavaCompiler createCompiler() throws CannotCreateJavaCompilerException {
        Throwable err1 = null;
        try {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler != null) {
                return compiler;
            }
        }
        catch (Throwable ex) {
            err1 = ex;
        }
        try {
            return (JavaCompiler)Class.forName("com.sun.tools.javac.api.JavacTool", true, JavacMain.class.getClassLoader()).newInstance();
        }
        catch (Throwable ex) {
            String message = (err1 != null ? JavacCompilerTool.formatErrorMessage("Error obtaining system java compiler", err1) + "\n" : "") + JavacCompilerTool.formatErrorMessage("System Java Compiler was not found in classpath", ex);
            throw new CannotCreateJavaCompilerException(message);
        }
    }

    @NotNull
    private static String formatErrorMessage(String header, Throwable ex) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(header);
        stringWriter.write(":\n");
        ex.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.getBuffer().toString();
    }

    @Override
    @NotNull
    public List<File> getAdditionalClasspath() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getDefaultCompilerOptions() {
        return Collections.singletonList("-implicit:class");
    }
}

