/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;

public final class ExtensionsSupport<T> {
    private final Class<T> myExtensionClass;
    private volatile List<T> myCached;

    public ExtensionsSupport(Class<T> extensionClass) {
        this.myExtensionClass = extensionClass;
    }

    @NotNull
    public Collection<T> getExtensions() {
        List<T> cached = this.myCached;
        if (cached != null) {
            return cached;
        }
        ServiceLoader<T> loader = ServiceLoader.load(this.myExtensionClass, this.myExtensionClass.getClassLoader());
        ArrayList<T> extensions = new ArrayList<T>();
        for (T extension : loader) {
            extensions.add(extension);
        }
        this.myCached = extensions;
        return extensions;
    }
}

