/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.sdk;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.issues.IssueCategory;
import com.android.tools.idea.apk.issues.SetupIssueReporter;
import com.android.tools.idea.apk.sdk.AndroidSdkSetup;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.AndroidSdkPathStore;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallPlatformQuickFix
extends NotificationHyperlink {
    @NotNull
    private final AndroidSdkSetup mySdkSetup;
    @NotNull
    private final ApkFacet myFacet;
    @NotNull
    private final File mySdkPath;
    @NotNull
    private final String mySdkVersion;
    @NotNull
    private final SdkManagerQuickFix myQuickFix;

    public InstallPlatformQuickFix(@NotNull AndroidSdkSetup sdkSetup, @NotNull ApkFacet facet, @NotNull File sdkPath, @NotNull String sdkVersion) {
        this(sdkSetup, facet, sdkPath, sdkVersion, SdkQuickfixUtils::createDialogForPaths);
    }

    @VisibleForTesting
    InstallPlatformQuickFix(@NotNull AndroidSdkSetup sdkSetup, @NotNull ApkFacet facet, @NotNull File sdkPath, @NotNull String sdkVersion, @NotNull SdkManagerQuickFix quickFix) {
        super("install.android.platform", "Install missing platform and fix project");
        this.mySdkSetup = sdkSetup;
        this.myFacet = facet;
        this.mySdkPath = sdkPath;
        this.mySdkVersion = sdkVersion;
        this.myQuickFix = quickFix;
    }

    protected void execute(@NotNull Project project) {
        AndroidVersion version = new AndroidVersion(Integer.parseInt(this.mySdkVersion), null);
        List<String> requested = Collections.singletonList(DetailsTypes.getPlatformPath((AndroidVersion)version));
        ModelWizardDialog dialog = this.myQuickFix.createSdkDialog(project, requested);
        if (dialog == null || dialog.showAndGet()) {
            ModifiableRootModel moduleModel = ModuleRootManager.getInstance((Module)this.myFacet.getModule()).getModifiableModel();
            ApplicationManager.getApplication().runWriteAction(() -> this.updateFromAndroidSdkPath(project));
            Sdk sdk = this.mySdkSetup.setUpSdk(this.mySdkVersion, this.mySdkPath, this.myFacet, moduleModel);
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (sdk != null) {
                    moduleModel.commit();
                    ((ApkFacetConfiguration)this.myFacet.getConfiguration()).removeIssues(IssueCategory.SDK_NOT_FOUND.name());
                    SetupIssueReporter.getInstance(project).reportSetupIssues(this.myFacet);
                } else {
                    moduleModel.dispose();
                }
            });
        }
    }

    private void updateFromAndroidSdkPath(@Nullable Project currentProject) {
        String resolved;
        Path sdkPath;
        File sdkDir = null;
        IdeSdks ideSdks = IdeSdks.getInstance();
        if (currentProject != null && !currentProject.isDisposed() && (sdkPath = AndroidSdkPathStore.getInstance().getAndroidSdkPath()) != null) {
            sdkDir = sdkPath.toFile();
        }
        if (sdkDir == null) {
            sdkDir = ideSdks.getAndroidSdkPath();
        }
        AndroidSdks.getInstance().setSdkData(AndroidSdkData.getSdkData((File)sdkDir));
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        for (Sdk sdk : ideSdks.getEligibleAndroidSdks()) {
            VirtualFile homeDir = sdk.getHomeDirectory();
            if (homeDir == null || !homeDir.exists()) {
                jdkTable.removeJdk(sdk);
                continue;
            }
            IAndroidTarget target = AndroidPlatform.getInstance((Sdk)sdk).getTarget();
            File targetFile = new File(target.getLocation());
            if (targetFile.exists()) continue;
            jdkTable.removeJdk(sdk);
        }
        try {
            resolved = FileUtil.resolveShortWindowsName((String)sdkDir.getPath());
        }
        catch (IOException e) {
            resolved = sdkDir.getPath();
        }
        ideSdks.createAndroidSdkPerAndroidTarget(new File(resolved));
    }

    @VisibleForTesting
    static interface SdkManagerQuickFix {
        @Nullable
        public ModelWizardDialog createSdkDialog(@Nullable Project var1, @NotNull Collection<String> var2);
    }
}

