/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.reload;

import com.android.tools.idea.apk.reload.ApkReloadException;
import com.android.tools.idea.apk.reload.Util;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.base.Strings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import java.util.List;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.UsesSdk;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SdkReader {
    private SdkReader() {
    }

    @Nullable
    public static String getSdkApiLevelFromModule(@NotNull Module module) {
        AndroidPlatform platform;
        AndroidSdkAdditionalData data;
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk != null && (data = AndroidSdks.getInstance().getAndroidSdkAdditionalData(sdk)) != null && (platform = data.getAndroidPlatform()) != null) {
            return String.valueOf(platform.getApiLevel());
        }
        return null;
    }

    @NotNull
    public static String getSdkApiLevelFromManifest(@NotNull AndroidFacet androidFacet) throws ApkReloadException {
        Manifest manifest = Manifest.getMainManifest((AndroidFacet)androidFacet);
        if (manifest == null) {
            throw new ApkReloadException("Failed to find AndroidManifest.xml file");
        }
        List usesSdks = (List)Util.invokeAndWait(() -> manifest.getUsesSdks());
        if (usesSdks.isEmpty()) {
            throw new ApkReloadException("AndroidManifest.xml file is missing <uses-sdk> tags");
        }
        UsesSdk usesSdk = (UsesSdk)usesSdks.get(0);
        String sdkVersion = (String)Util.invokeAndWait(() -> SdkReader.getTargetSdkVersion(usesSdk));
        if (Strings.isNullOrEmpty((String)sdkVersion)) {
            sdkVersion = (String)Util.invokeAndWait(() -> SdkReader.getMinSdkVersion(usesSdk));
        }
        if (sdkVersion == null) {
            throw new ApkReloadException("AndroidManifest.xml file does not set SDK version");
        }
        return sdkVersion;
    }

    @Nullable
    private static String getTargetSdkVersion(@NotNull UsesSdk usesSdk) {
        AndroidAttributeValue targetSdkVersion = usesSdk.getTargetSdkVersion();
        return targetSdkVersion.exists() ? (String)targetSdkVersion.getValue() : null;
    }

    @Nullable
    private static String getMinSdkVersion(@NotNull UsesSdk usesSdk) {
        AndroidAttributeValue minSdkVersion = usesSdk.getMinSdkVersion();
        return minSdkVersion.exists() ? (String)minSdkVersion.getValue() : null;
    }
}

