/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor.notification;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.OpenLibraryInEditorAction;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.editor.notification.AddSymbolsForAllLibrariesAction;
import com.android.tools.idea.apk.editor.notification.DropDownAction;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingDebugSymbolsNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"apk.missing.debug.symbols");
    @NotNull
    private final Project myProject;

    public MissingDebugSymbolsNotificationProvider(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        ApkFacet facet;
        if ("apk".equals(file.getExtension()) && (facet = this.findLibrariesWithoutSymbols()) != null) {
            MyEditorNotificationPanel panel = new MyEditorNotificationPanel();
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
            List libraries = ((ApkFacetConfiguration)facet.getConfiguration()).getLibrariesWithoutDebugSymbols();
            if (libraries.size() == 1) {
                NativeLibrary library = (NativeLibrary)libraries.get(0);
                panel.setText(library.name + " is missing debug symbols");
                OpenLibraryInEditorAction action = new OpenLibraryInEditorAction(library, fileEditorManager);
                panel.addToLinksPanel((Component)((Object)new OpenLibraryInEditorHyperlinkLabel(action, panel.getBackground())));
            } else {
                panel.setText("Libraries (*.so) in the APK are missing debug symbols");
                DropDownAction dropDown = new DropDownAction("Select library to add debug symbols ");
                dropDown.addAction(new AddSymbolsForAllLibrariesAction(facet, file, libraries));
                for (NativeLibrary library : libraries) {
                    dropDown.addAction(new OpenLibraryInEditorAction(library.name, library, fileEditorManager));
                }
                panel.addToLinksPanel((Component)((Object)dropDown));
            }
            return panel;
        }
        return null;
    }

    @Nullable
    private ApkFacet findLibrariesWithoutSymbols() {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ApkFacetConfiguration configuration;
            List libraries;
            ApkFacet facet = ApkFacet.getInstance((Module)module);
            if (facet == null || (libraries = (configuration = (ApkFacetConfiguration)facet.getConfiguration()).getLibrariesWithoutDebugSymbols()).isEmpty()) continue;
            return facet;
        }
        return null;
    }

    @VisibleForTesting
    static class OpenLibraryInEditorHyperlinkLabel
    extends HyperlinkLabel {
        @NotNull
        private final NativeLibrary myLibrary;

        OpenLibraryInEditorHyperlinkLabel(@NotNull OpenLibraryInEditorAction action, @NotNull Color background) {
            super("Add debug symbols", background);
            this.addHyperlinkListener(action);
            this.myLibrary = action.getLibrary();
        }

        @VisibleForTesting
        protected void fireHyperlinkEvent(@Nullable InputEvent inputEvent) {
            super.fireHyperlinkEvent(inputEvent);
        }

        @NotNull
        NativeLibrary getLibrary() {
            return this.myLibrary;
        }
    }

    @VisibleForTesting
    static class MyEditorNotificationPanel
    extends EditorNotificationPanel {
        @NotNull
        private final List<Component> myLinkComponents = new ArrayList<Component>();

        MyEditorNotificationPanel() {
        }

        void addToLinksPanel(@NotNull Component component) {
            this.myLinksPanel.add(component);
            this.myLinkComponents.add(component);
        }

        @VisibleForTesting
        @NotNull
        List<Component> getLinkComponents() {
            return this.myLinkComponents;
        }
    }
}

