/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor;

import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.editor.PathMappingNode;
import com.android.tools.idea.apk.paths.PathNode;
import com.android.tools.idea.apk.paths.PathNodeParent;
import com.android.tools.idea.apk.paths.PathTree;
import com.android.tools.idea.apk.symbols.ui.PathMapping;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteFile;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

class PathMappingRootNode
extends DefaultMutableTreeNode {
    @NotNull
    private final NativeLibrary myLibrary;

    PathMappingRootNode(@NotNull NativeLibrary library) {
        this.myLibrary = library;
    }

    void updateChildren() {
        this.removeAllChildren();
        Set entries = this.myLibrary.pathMappings.entrySet();
        if (!entries.isEmpty()) {
            ArrayList<String> originalPaths = new ArrayList<String>();
            for (Map.Entry entry : entries) {
                originalPaths.add((String)entry.getKey());
            }
            Collections.sort(originalPaths);
            PathTree tree = new PathTree();
            for (String originalPath : originalPaths) {
                boolean isWindows = RemoteFile.isWindowsPath((String)originalPath) || originalPath.startsWith(".\\") || originalPath.startsWith("..\\");
                tree.addPath(originalPath, isWindows ? (char)'\\' : '/');
            }
            for (PathNode pathNode : tree.getChildren()) {
                this.addPathMapping(this, pathNode);
            }
            TreeUtil.traverse((TreeNode)this, node -> {
                if (node instanceof PathMappingNode) {
                    PathMappingNode pathMappingNode = (PathMappingNode)node;
                    pathMappingNode.updateDisplayedText();
                    PathMapping pathMapping = pathMappingNode.getPathMapping();
                    String mappedPath = (String)this.myLibrary.pathMappings.get(pathMapping.getOriginalPath());
                    if (!StringUtil.isEmpty((String)mappedPath)) {
                        pathMapping.setSelectedPath(mappedPath);
                    } else {
                        pathMappingNode.deriveSelectedPathFromParent();
                    }
                }
                return true;
            });
        }
    }

    private void addPathMapping(@NotNull DefaultMutableTreeNode treeNode, @NotNull PathNode pathNode) {
        DefaultMutableTreeNode parent = pathNode.getPathSegment().isEmpty() && pathNode.getPath().isEmpty() ? treeNode : this.getOrCreateParent(treeNode, pathNode);
        for (PathNode child : pathNode.getChildren()) {
            this.addPathMapping(parent, child);
        }
    }

    @NotNull
    private PathMappingNode getOrCreateParent(@NotNull DefaultMutableTreeNode treeNode, @NotNull PathNode pathNode) {
        if (PathMappingRootNode.shouldForceNodeCreation(pathNode)) {
            return this.createAndAddChild(treeNode, pathNode);
        }
        if (treeNode instanceof PathMappingNode) {
            PathMappingNode node = (PathMappingNode)treeNode;
            node.update(pathNode.getPathSegment(), pathNode.getPath());
            return node;
        }
        return this.createAndAddChild(treeNode, pathNode);
    }

    @NotNull
    private PathMappingNode createAndAddChild(@NotNull DefaultMutableTreeNode treeNode, @NotNull PathNode pathNode) {
        String filePath = pathNode.getPath();
        String mappedPath = "";
        if (this.myLibrary.containsMappingForRemotePath(filePath)) {
            mappedPath = (String)this.myLibrary.pathMappings.get(filePath);
        }
        PathMapping pathMapping = new PathMapping(filePath, mappedPath);
        PathMappingNode child = new PathMappingNode(pathNode.getPathSegment(), pathMapping);
        treeNode.add(child);
        child.deriveSelectedPathFromParent();
        return child;
    }

    private static boolean shouldForceNodeCreation(@NotNull PathNode pathNode) {
        PathNodeParent parent = pathNode.getParent();
        return parent != null && parent.getChildren().size() > 1;
    }

    @NotNull
    NativeLibrary getLibrary() {
        return this.myLibrary;
    }
}

