/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class LibraryUpdates {
    private static final Topic<Listener> TOPIC = new Topic("Native Library changes", Listener.class);
    @NotNull
    private final MessageBus myMessageBus;

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull Listener listener, @NotNull Disposable parent) {
        MessageBusConnection connection = project.getMessageBus().connect(parent);
        connection.subscribe(TOPIC, (Object)listener);
        return connection;
    }

    @NotNull
    public static LibraryUpdates getInstance(@NotNull Project project) {
        return (LibraryUpdates)project.getService(LibraryUpdates.class);
    }

    public LibraryUpdates(@NotNull MessageBus messageBus) {
        this.myMessageBus = messageBus;
    }

    public void notifyLibrariesChanged(@NotNull Collection<NativeLibrary> libraries) {
        ((Listener)this.myMessageBus.syncPublisher(TOPIC)).librariesChanged(libraries);
    }

    public static interface Listener {
        public void librariesChanged(@NotNull Collection<NativeLibrary> var1);
    }
}

