/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.project.AndroidProjectInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.testFramework.LightVirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class ApkWritingAccessProvider
extends WritingAccessProvider {
    @NotNull
    private final AndroidProjectInfo myAndroidProjectInfo;

    public ApkWritingAccessProvider(@NotNull Project project) {
        this(AndroidProjectInfo.getInstance((Project)project));
    }

    ApkWritingAccessProvider(@NotNull AndroidProjectInfo androidProjectInfo) {
        this.myAndroidProjectInfo = androidProjectInfo;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(VirtualFile ... files) {
        if (!this.myAndroidProjectInfo.isApkProject()) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> denied = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            if (ApkWritingAccessProvider.isInMemoryFile(file)) continue;
            denied.add(file);
        }
        return denied;
    }

    public boolean isPotentiallyWritable(@NotNull VirtualFile file) {
        if (!this.myAndroidProjectInfo.isApkProject()) {
            return true;
        }
        return ApkWritingAccessProvider.isInMemoryFile(file);
    }

    private static boolean isInMemoryFile(@NotNull VirtualFile file) {
        return file instanceof LightVirtualFile;
    }
}

