/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.apk.ApkDebuggingUsageTracker;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFileType;
import com.android.tools.idea.apk.ApkImportPathProperty;
import com.android.tools.idea.apk.ApkModuleFactory;
import com.android.tools.idea.apk.ApkModuleSetup;
import com.android.tools.idea.apk.ApkProjectFolder;
import com.android.tools.idea.apk.ApkSetupContext;
import com.android.tools.idea.apk.AsyncResult;
import com.android.tools.idea.apk.FileWatcherService;
import com.android.tools.idea.apk.issues.SetupIssueReporter;
import com.android.tools.idea.apk.reload.ApkReloader;
import com.android.tools.idea.apk.reload.Util;
import com.android.tools.idea.apk.setup.ProjectApkFileSetup;
import com.android.tools.idea.apk.setup.project.ProjectSdkSetup;
import com.android.tools.idea.gradle.project.importing.ProjectFolder;
import com.android.tools.idea.project.CustomProjectTypeImporter;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.idea.util.ToolWindows;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkProjectImporter
extends CustomProjectTypeImporter {
    @NotNull
    private final ProjectFolder.Factory myProjectFolderFactory;
    @NotNull
    private final ApkProjectFolder myProjectFolder;
    @NotNull
    private final ProjectApkFileSetup myApkFileSetup;
    @NotNull
    private final ApkModuleFactory myApkModuleFactory;
    @NotNull
    private final ApkModuleSetup myApkModuleSetup;
    @NotNull
    private final ProjectSdkSetup myProjectSdkSetup;
    @NotNull
    private final FileOpener myFileOpener;

    public ApkProjectImporter() {
        this(new ProjectFolder.Factory(), new ApkProjectFolder(), new ProjectApkFileSetup(), new ApkModuleFactory(), new ApkModuleSetup(), new ProjectSdkSetup(), OpenFileAction::openFile);
    }

    @VisibleForTesting
    public ApkProjectImporter(@NotNull ProjectFolder.Factory projectFolderFactory, @NotNull ApkProjectFolder projectFolder, @NotNull ProjectApkFileSetup apkFileSetup, @NotNull ApkModuleFactory apkModuleFactory, @NotNull ApkModuleSetup apkModuleSetup, @NotNull ProjectSdkSetup projectSdkSetup, @NotNull FileOpener fileOpener) {
        this.myProjectFolderFactory = projectFolderFactory;
        this.myProjectFolder = projectFolder;
        this.myApkFileSetup = apkFileSetup;
        this.myApkModuleFactory = apkModuleFactory;
        this.myApkModuleSetup = apkModuleSetup;
        this.myProjectSdkSetup = projectSdkSetup;
        this.myFileOpener = fileOpener;
    }

    public boolean canImport(@NotNull VirtualFile file) {
        return FileTypeChooser.getKnownFileTypeOrAssociate((VirtualFile)file, null) instanceof ApkFileType;
    }

    public void reloadExistingProject(@NotNull VirtualFile existingProjectFolder, final @NotNull VirtualFile newApkFile) throws Exception {
        final Project project = this.myProjectFolder.getOrOpenProject(existingProjectFolder);
        assert (Util.isApkProject(project));
        final VirtualFile oldApkFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.join((String[])new String[]{existingProjectFolder.getPath(), newApkFile.getName()}));
        assert (oldApkFile != null);
        ProgressManager.getInstance().run((Task)new Task.Modal(project, "Import New APK", false){

            public void run(@NotNull ProgressIndicator indicator) {
                ApkReloader reloader = new ApkReloader(project, indicator);
                reloader.reload(oldApkFile, newApkFile);
                EditorNotifications.getInstance((Project)project).updateNotifications(newApkFile);
            }
        });
    }

    public void importFile(@NotNull VirtualFile newApkFile) {
        try {
            File existingProjectFolderPath = this.myProjectFolder.getDefaultProjectFolder(newApkFile);
            if (existingProjectFolderPath.isDirectory()) {
                String projectName = newApkFile.getNameWithoutExtension();
                ApkProjectFolder.ImportApkDialogOption answer = this.myProjectFolder.showImportApkDialog(projectName);
                if (answer == null) {
                    return;
                }
                switch (answer) {
                    case RELOAD_EXISTING_PROJECT: 
                    case OVERWRITE_EXISTING_PROJECT: {
                        VirtualFile existingProjectFolder = VfsUtil.findFileByIoFile((File)existingProjectFolderPath, (boolean)true);
                        assert (existingProjectFolder != null);
                        if (answer == ApkProjectFolder.ImportApkDialogOption.RELOAD_EXISTING_PROJECT) {
                            this.reloadExistingProject(existingProjectFolder, newApkFile);
                            break;
                        }
                        this.myProjectFolder.deleteExistingProjectFolder(existingProjectFolderPath);
                        this.importFileToFolder(existingProjectFolder, newApkFile);
                        break;
                    }
                    case USE_NEW_PROJECT: {
                        VirtualFile newProjectFolder = this.myProjectFolder.createNewProjectFolder(newApkFile);
                        this.importFileToFolder(newProjectFolder, newApkFile);
                        break;
                    }
                }
            } else {
                VirtualFile projectRootFolder = this.myProjectFolder.createNewProjectFolder(newApkFile);
                this.importFileToFolder(projectRootFolder, newApkFile);
            }
        }
        catch (Throwable e) {
            ApkProjectImporter.showAndLogError(e);
        }
    }

    private void importFileToFolder(@NotNull VirtualFile projectRootFolder, @NotNull VirtualFile newApkFile) throws IOException {
        File projectRootFolderPath = VfsUtilCore.virtualToIoFile((VirtualFile)projectRootFolder);
        ProjectFolder projectFolder = this.myProjectFolderFactory.create(projectRootFolderPath);
        projectFolder.createIdeaProjectFolder();
        ProjectManager projectManager = ProjectManager.getInstance();
        Project newProject = projectManager.createProject(projectRootFolderPath.getName(), projectRootFolderPath.getPath());
        if (newProject == null) {
            throw new NullPointerException("Failed to create a new project");
        }
        this.setUpApkProjectAsynchronous(newProject, projectRootFolderPath, newApkFile);
    }

    private void setUpApkProjectAsynchronous(@NotNull Project project, @NotNull File projectRootFolderPath, @NotNull VirtualFile inputApkFile) {
        VirtualFile baseDir = VfsUtil.findFileByIoFile((File)projectRootFolderPath, (boolean)true);
        AsyncResult<VirtualFile> callback = this.setUpApkFile(project, inputApkFile, baseDir);
        callback.doWhenDone(() -> {
            VirtualFile projectApkFile = (VirtualFile)callback.getResult();
            assert (projectApkFile != null);
            this.createAndSetupMainModule(project, projectApkFile, inputApkFile);
            ProjectManagerEx.getInstanceEx().openProject(projectRootFolderPath.toPath(), new OpenProjectTask(true, null, false, false, project, null, true, null, null, -1, -1, true, false, true, null, false, true, null, null, null));
        });
        callback.doWhenRejected(() -> {
            Throwable error = callback.getUnexpectedError();
            assert (error != null);
            ApkProjectImporter.showAndLogError(error);
        });
    }

    @NotNull
    private AsyncResult<VirtualFile> setUpApkFile(@NotNull Project project, final @NotNull VirtualFile apkFile, final @NotNull VirtualFile projectRootFolder) {
        final AsyncResult<VirtualFile> callback = new AsyncResult<VirtualFile>();
        Task.Modal task = new Task.Modal(project, "Set Up APK", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                try {
                    VirtualFile copy = ApkProjectImporter.this.setUpApkFile(apkFile, projectRootFolder, indicator);
                    if (copy != null) {
                        callback.setDone(copy);
                        return;
                    }
                    callback.setRejected(new FileNotFoundException("Failed to find APK file in the project"));
                }
                catch (Throwable error) {
                    callback.setRejected(error);
                }
            }
        };
        task.queue();
        return callback;
    }

    @Nullable
    private VirtualFile setUpApkFile(@NotNull VirtualFile apkFile, @NotNull VirtualFile projectRootFolder, @Nullable ProgressIndicator indicator) throws IOException, ExecutionException, InterruptedException {
        Path apkFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)apkFile).toPath();
        Path destination = VfsUtilCore.virtualToIoFile((VirtualFile)projectRootFolder).toPath();
        Path copyPath = this.myApkFileSetup.setUpApk(apkFilePath, destination, indicator);
        return VfsUtil.findFileByIoFile((File)copyPath.toFile(), (boolean)true);
    }

    private void createAndSetupMainModule(@NotNull Project project, @NotNull VirtualFile apkFile, @NotNull VirtualFile inputApkFile) {
        this.myProjectSdkSetup.setUpProject(project);
        try {
            ApkSetupContext context = this.myApkModuleFactory.createApkModule(project, apkFile);
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            if (!unitTestMode) {
                project.save();
            }
            ApkImportPathProperty.setPath(project, inputApkFile);
            ApkImportPathProperty.setTimestamp(project, inputApkFile);
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                try {
                    this.myApkModuleSetup.setUpApkModule(project, context);
                    try {
                        this.myFileOpener.openFile(context.getApkFile(), project);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ApkFacet facet = context.getApkFacet();
                    assert (facet != null);
                    facet.signalFacetConfigurationChanged();
                    ApkDebuggingUsageTracker.logEvent(facet, AndroidStudioEvent.EventKind.APK_DEBUG_IMPORT);
                    SetupIssueReporter.getInstance(project).reportSetupIssues(facet);
                    ((FileWatcherService)project.getService(FileWatcherService.class)).setApkPathToWatch(inputApkFile.getPath());
                }
                catch (Throwable e) {
                    ApkProjectImporter.showAndLogError(e);
                }
                if (!unitTestMode) {
                    ApplicationManager.getApplication().invokeLater(() -> ToolWindows.activateProjectView((Project)project));
                }
            });
        }
        catch (Throwable e) {
            ApkProjectImporter.showAndLogError(e);
        }
    }

    private static void showAndLogError(@NotNull Throwable e) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
            return;
        }
        Messages.showErrorDialog((String)e.getMessage(), (String)"APK Import");
        ApkProjectImporter.getLog().error(e);
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(ApkProjectImporter.class);
    }

    @VisibleForTesting
    public void setUpApkProjectSynchronous(@NotNull Project project, @NotNull VirtualFile inputApkFile) throws InterruptedException, ExecutionException, IOException {
        VirtualFile projectApkFile = this.setUpApkFile(inputApkFile, project.getBaseDir(), null);
        assert (projectApkFile != null);
        this.createAndSetupMainModule(project, projectApkFile, inputApkFile);
        Path projectRootFolderPath = FileExtensions.toIoFile((VirtualFile)ProjectUtil.guessProjectDir((Project)project)).toPath();
        ProjectManagerEx.getInstanceEx().openProject(projectRootFolderPath, new OpenProjectTask(true, null, false, false, project, null, true, null, null, -1, -1, true, false, true, null, false, true, null, null, null));
    }

    @VisibleForTesting
    public static interface FileOpener {
        public void openFile(@NotNull VirtualFile var1, @NotNull Project var2);
    }
}

