/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.Projects;
import com.android.tools.idea.apk.ApkSetupContext;
import com.android.tools.idea.apk.setup.module.AndroidFacetSetupStep;
import com.android.tools.idea.apk.setup.module.ApkFacetSetupStep;
import com.android.tools.idea.apk.setup.module.ApkModuleSetupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class ApkModuleFactory {
    @NotNull
    private final ApkModuleSetupStep[] mySetupSteps;

    public ApkModuleFactory() {
        this(new AndroidFacetSetupStep(), new ApkFacetSetupStep());
    }

    @VisibleForTesting
    ApkModuleFactory(ApkModuleSetupStep ... setupSteps) {
        this.mySetupSteps = setupSteps;
    }

    @NotNull
    ApkSetupContext createApkModule(@NotNull Project project, @NotNull VirtualFile apkFile) throws Throwable {
        File projectRootFolderPath = Projects.getBaseDirPath((Project)project);
        IdeModifiableModelsProvider modelsProvider = ProjectDataManager.getInstance().createModifiableModelsProvider(project);
        try {
            File moduleFile = new File(projectRootFolderPath, projectRootFolderPath.getName() + ".iml");
            Module module = modelsProvider.newModule(moduleFile.getPath(), StdModuleTypes.JAVA.getId());
            ApkSetupContext context = new ApkSetupContext(module, modelsProvider, apkFile);
            for (ApkModuleSetupStep step : this.mySetupSteps) {
                step.setUpModule(modelsProvider, context);
            }
            ApkModuleFactory.commitChanges(project, modelsProvider);
            return context;
        }
        catch (Exception e) {
            ApkModuleFactory.disposeChanges(project, modelsProvider);
            throw e;
        }
    }

    private static void commitChanges(@NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                modelsProvider.commit();
            }
        });
    }

    private static void disposeChanges(@NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                modelsProvider.dispose();
            }
        });
    }
}

