/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.networksimplex;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.elk.alg.layered.networksimplex.NEdge;
import org.eclipse.elk.alg.layered.networksimplex.NNode;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class NGraph {
    public List<NNode> nodes = Lists.newArrayList();

    public void writeDebugGraph(String filePath) {
        ElkNode elkGraph = ElkGraphUtil.createGraph();
        elkGraph.setProperty(LayeredOptions.DIRECTION, (Object)Direction.DOWN);
        HashMap nodeMap = Maps.newHashMap();
        for (NNode nNode : this.nodes) {
            ElkNode elkNode = ElkGraphUtil.createNode((ElkNode)elkGraph);
            nodeMap.put(nNode, elkNode);
            ElkGraphUtil.createLabel((String)(String.valueOf(nNode.type) + " " + nNode.layer), (ElkGraphElement)elkNode);
        }
        for (NNode nNode : this.nodes) {
            for (NEdge nEdge : nNode.getOutgoingEdges()) {
                ElkEdge elkEdge = ElkGraphUtil.createSimpleEdge((ElkConnectableShape)((ElkConnectableShape)nodeMap.get(nEdge.source)), (ElkConnectableShape)((ElkConnectableShape)nodeMap.get(nEdge.target)));
                ElkGraphUtil.createLabel((String)(String.valueOf(nEdge.weight) + " " + nEdge.delta), (ElkGraphElement)elkEdge);
            }
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createFileURI((String)filePath));
        r.getContents().add((Object)elkGraph);
        try {
            r.save(Collections.emptyMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final NNode makeConnected() {
        int id = 0;
        for (NNode n : this.nodes) {
            n.internalId = id++;
        }
        List<NNode> ccRep = this.findConCompRepresentatives();
        NNode root = null;
        if (ccRep.size() > 1) {
            root = this.createArtificialRootAndConnect(ccRep);
        }
        return root;
    }

    private NNode createArtificialRootAndConnect(List<NNode> nodesToConnect) {
        NNode root = NNode.of().create(this);
        for (NNode src : nodesToConnect) {
            NEdge.of().delta(0).weight(0.0).source(root).target(src).create();
        }
        return root;
    }

    private List<NNode> findConCompRepresentatives() {
        ArrayList ccRep = Lists.newArrayList();
        boolean[] mark = new boolean[this.nodes.size()];
        Arrays.fill(mark, false);
        for (NNode node : this.nodes) {
            if (mark[node.internalId]) continue;
            ccRep.add(node);
            this.dfs(node, mark);
        }
        return ccRep;
    }

    private void dfs(NNode node, boolean[] mark) {
        if (mark[node.internalId]) {
            return;
        }
        mark[node.internalId] = true;
        for (NEdge edge : node.getConnectedEdges()) {
            NNode other = edge.getOther(node);
            this.dfs(other, mark);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean isAcyclic() {
        id = 0;
        for (NNode n : this.nodes) {
            n.internalId = id++;
        }
        incident = new int[this.nodes.size()];
        layer = new int[this.nodes.size()];
        for (NNode node : this.nodes) {
            v0 = node.internalId;
            incident[v0] = incident[v0] + node.getIncomingEdges().size();
        }
        roots = Lists.newLinkedList();
        for (NNode node : this.nodes) {
            if (!node.getIncomingEdges().isEmpty()) continue;
            roots.add(node);
        }
        if (!roots.isEmpty() || this.nodes.isEmpty()) ** GOTO lbl29
        return false;
lbl-1000:
        // 1 sources

        {
            node = (NNode)roots.poll();
            for (NEdge edge : node.getOutgoingEdges()) {
                target = edge.getTarget();
                layer[target.internalId] = Math.max(layer[target.internalId], layer[node.internalId] + 1);
                v1 = target.internalId;
                incident[v1] = incident[v1] - 1;
                if (incident[target.internalId] != 0) continue;
                roots.add(target);
            }
lbl29:
            // 2 sources

            ** while (!roots.isEmpty())
        }
lbl30:
        // 2 sources

        for (NNode node : this.nodes) {
            for (NEdge edge : node.getOutgoingEdges()) {
                if (layer[edge.target.internalId] > layer[edge.source.internalId]) continue;
                return false;
            }
        }
        return true;
    }
}

