/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAnnotationNotApplicableInspection
extends LocalInspectionTool {
    protected abstract String getAnnotationName(Project var1);

    protected abstract boolean isTypeApplicable(PsiType var1);

    @InspectionMessage
    protected abstract String getDescriptionTemplate();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){
            final String annotationName;
            {
                this.annotationName = AbstractAnnotationNotApplicableInspection.this.getAnnotationName(holder.getProject());
            }

            public void visitAnnotation(PsiAnnotation annotation) {
                PsiClass psiClass;
                String name = annotation.getQualifiedName();
                if (this.annotationName.equals(name)) {
                    AbstractAnnotationNotApplicableInspection.this.checkAnnotation(annotation, holder);
                } else if (name != null && (psiClass = JavaPsiFacade.getInstance((Project)annotation.getProject()).findClass(name, annotation.getResolveScope())) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)this.annotationName, (int)2)) {
                    AbstractAnnotationNotApplicableInspection.this.checkAnnotation(annotation, holder);
                }
            }
        };
    }

    private void checkAnnotation(PsiAnnotation annotation, ProblemsHolder holder) {
        PsiType type;
        PsiModifierListOwner owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierListOwner.class);
        if (owner instanceof PsiVariable) {
            PsiType type2 = ((PsiVariable)owner).getType();
            if (this.isTypeApplicable(type2)) {
                this.registerProblem(annotation, holder);
            }
        } else if (owner instanceof PsiMethod && this.isTypeApplicable(type = ((PsiMethod)owner).getReturnType())) {
            this.registerProblem(annotation, holder);
        }
    }

    private void registerProblem(PsiAnnotation annotation, ProblemsHolder holder) {
        holder.registerProblem((PsiElement)annotation, this.getDescriptionTemplate(), new LocalQuickFix[]{new RemoveAnnotationQuickFix(annotation, null)});
    }
}

