/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.xml;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.PairProcessor;
import com.intellij.util.PatternValuesIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.config.AbstractTagInjection;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class XmlLanguageInjector
implements MultiHostInjector {
    private final Configuration myConfiguration;
    private volatile Trinity<Long, Pattern, Collection<String>> myXmlIndex;

    public XmlLanguageInjector(@NotNull Project project) {
        this.myConfiguration = Configuration.getProjectInstance(project);
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        return Arrays.asList(XmlTag.class, XmlAttributeValue.class);
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        XmlElement xmlElement = (XmlElement)host;
        if (!this.isInIndex(xmlElement)) {
            return;
        }
        TreeSet<TextRange> ranges = new TreeSet<TextRange>(InjectorUtils.RANGE_COMPARATOR);
        PsiFile containingFile = xmlElement.getContainingFile();
        Ref unparsableRef = Ref.create();
        this.getInjectedLanguage((PsiElement)xmlElement, (Ref<? super Boolean>)unparsableRef, (PairProcessor<? super Language, ? super List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>>>)((PairProcessor)(language, list) -> {
            for (Trinity trinity : list) {
                if (!ranges.contains(((TextRange)trinity.third).shiftRight(((PsiLanguageInjectionHost)trinity.first).getTextRange().getStartOffset()))) continue;
                return true;
            }
            for (Trinity trinity : list) {
                PsiLanguageInjectionHost host1 = (PsiLanguageInjectionHost)trinity.first;
                if (host1.getContainingFile() != containingFile) continue;
                TextRange textRange = (TextRange)trinity.third;
                ranges.add(textRange.shiftRight(host1.getTextRange().getStartOffset()));
            }
            InjectorUtils.registerInjection(language, list, containingFile, registrar);
            InjectorUtils.registerSupport(InjectorUtils.findNotNullInjectionSupport("xml"), true, (PsiElement)((Trinity)list.get(0)).getFirst(), language);
            if (Boolean.TRUE.equals(unparsableRef.get())) {
                InjectorUtils.putInjectedFileUserData(host, language, InjectedLanguageUtil.FRANKENSTEIN_INJECTION, Boolean.TRUE);
            }
            return true;
        }));
    }

    void getInjectedLanguage(PsiElement place, final Ref<? super Boolean> unparsableRef, PairProcessor<? super Language, ? super List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>>> processor) {
        block13: {
            block14: {
                if (!(place instanceof XmlTag)) break block14;
                XmlTag xmlTag = (XmlTag)place;
                List<BaseInjection> injections = this.myConfiguration.getInjections("xml");
                int injectionsSize = injections.size();
                for (int i = 0; i < injectionsSize; ++i) {
                    Language language;
                    final BaseInjection injection = injections.get(i);
                    if (!injection.acceptsPsiElement((PsiElement)xmlTag) || (language = InjectedLanguage.findLanguageById(injection.getInjectedLanguageId())) == null) continue;
                    final boolean separateFiles = !injection.isSingleFile() && StringUtil.isNotEmpty((String)injection.getValuePattern());
                    final ArrayList result = new ArrayList();
                    xmlTag.acceptChildren(new PsiElementVisitor(){

                        public void visitElement(@NotNull PsiElement element) {
                            if (element instanceof XmlText) {
                                if (!(element instanceof PsiLanguageInjectionHost) || element.getTextLength() == 0) {
                                    return;
                                }
                                if (!injection.shouldBeIgnored(element)) {
                                    List<TextRange> list = injection.getInjectedArea(element);
                                    InjectedLanguage l = InjectedLanguage.create(injection.getInjectedLanguageId(), injection.getPrefix(), injection.getSuffix(), false);
                                    for (TextRange textRange : list) {
                                        result.add(Trinity.create((Object)((PsiLanguageInjectionHost)element), (Object)l, (Object)textRange));
                                    }
                                }
                            } else if (element instanceof XmlTag) {
                                if (!separateFiles) {
                                    unparsableRef.set((Object)Boolean.TRUE);
                                }
                                if (injection instanceof AbstractTagInjection && ((AbstractTagInjection)injection).isApplyToSubTags()) {
                                    element.acceptChildren((PsiElementVisitor)this);
                                }
                            }
                        }
                    });
                    if (!result.isEmpty()) {
                        if (separateFiles) {
                            for (Trinity trinity : result) {
                                processor.process((Object)language, Collections.singletonList(trinity));
                            }
                        } else {
                            processor.process((Object)language, result);
                        }
                    }
                    if (!injection.isTerminal()) {
                        continue;
                    }
                    break block13;
                }
                break block13;
            }
            if (!(place instanceof XmlAttributeValue) || !(place.getParent() instanceof XmlAttribute)) break block13;
            XmlAttribute attribute = (XmlAttribute)place.getParent();
            XmlAttributeValue value = (XmlAttributeValue)place;
            PsiElement[] children = value.getChildren();
            if (children.length < 3 || !(children[1] instanceof XmlToken) || ((XmlToken)children[1]).getTokenType() != XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                return;
            }
            List<BaseInjection> injections = this.myConfiguration.getInjections("xml");
            int size = injections.size();
            for (int i = 0; i < size; ++i) {
                Language language;
                BaseInjection injection = injections.get(i);
                if (!injection.acceptsPsiElement((PsiElement)attribute) || injection.shouldBeIgnored((PsiElement)value) || (language = InjectedLanguage.findLanguageById(injection.getInjectedLanguageId())) == null) continue;
                boolean separateFiles = !injection.isSingleFile() && StringUtil.isNotEmpty((String)injection.getValuePattern());
                List<TextRange> ranges = injection.getInjectedArea((PsiElement)value);
                if (ranges.isEmpty()) continue;
                ArrayList<Trinity> result = new ArrayList<Trinity>();
                InjectedLanguage l = InjectedLanguage.create(injection.getInjectedLanguageId(), injection.getPrefix(), injection.getSuffix(), false);
                for (TextRange textRange : ranges) {
                    result.add(Trinity.create((Object)((PsiLanguageInjectionHost)value), (Object)l, (Object)textRange));
                }
                if (separateFiles) {
                    for (Trinity trinity : result) {
                        processor.process((Object)language, Collections.singletonList(trinity));
                    }
                } else {
                    processor.process((Object)language, result);
                }
                if (!injection.isTerminal()) {
                    continue;
                }
                break;
            }
        }
    }

    private boolean isInIndex(XmlElement xmlElement) {
        XmlTag tag;
        Trinity<Long, Pattern, Collection<String>> index = this.getXmlAnnotatedElementsValue();
        if (xmlElement instanceof XmlAttributeValue) {
            xmlElement = (XmlElement)xmlElement.getParent();
        }
        if (xmlElement instanceof XmlAttribute) {
            XmlAttribute attribute = (XmlAttribute)xmlElement;
            if (XmlLanguageInjector.areThereInjectionsWithText(attribute.getLocalName(), index)) {
                return true;
            }
            if (XmlLanguageInjector.areThereInjectionsWithText(attribute.getValue(), index)) {
                return true;
            }
            tag = attribute.getParent();
            if (tag == null) {
                return false;
            }
        } else if (xmlElement instanceof XmlTag) {
            tag = (XmlTag)xmlElement;
        } else {
            return false;
        }
        return XmlLanguageInjector.areThereInjectionsWithText(tag.getLocalName(), index);
    }

    private static boolean areThereInjectionsWithText(String text, Trinity<Long, Pattern, Collection<String>> index) {
        if (text == null) {
            return false;
        }
        if (((Collection)index.third).contains(text)) {
            return true;
        }
        Pattern pattern = (Pattern)index.second;
        return pattern != null && pattern.matcher(text).matches();
    }

    private Trinity<Long, Pattern, Collection<String>> getXmlAnnotatedElementsValue() {
        Trinity index = this.myXmlIndex;
        if (index == null || this.myConfiguration.getModificationCount() != ((Long)index.first).longValue()) {
            HashMap<ElementPattern<? extends PsiElement>, BaseInjection> map = new HashMap<ElementPattern<? extends PsiElement>, BaseInjection>();
            for (BaseInjection injection : this.myConfiguration.getInjections("xml")) {
                for (InjectionPlace place : injection.getInjectionPlaces()) {
                    if (!place.isEnabled() || place.getElementPattern() == null) continue;
                    map.put(place.getElementPattern(), injection);
                }
            }
            Set stringSet = PatternValuesIndex.buildStringIndex(map.keySet());
            this.myXmlIndex = index = Trinity.create((Object)this.myConfiguration.getModificationCount(), (Object)XmlLanguageInjector.buildPattern(stringSet), (Object)stringSet);
        }
        return index;
    }

    @Nullable
    private static Pattern buildPattern(Collection<String> stringSet) {
        StringBuilder sb = new StringBuilder();
        for (String s : stringSet) {
            if (!InjectorUtils.isRegexp(s)) continue;
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append("(?:").append(s).append(")");
        }
        return sb.length() == 0 ? null : Pattern.compile(sb.toString());
    }
}

