/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java.validation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.psiutils.CollectionUtils;
import java.util.Set;
import javax.swing.JComponent;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.util.AnnotateFix;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageMismatch
extends LocalInspectionTool {
    public boolean CHECK_NON_ANNOTATED_REFERENCES = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(IntelliLangBundle.message("flag.usages.of.non.annotated.elements", new Object[0]), (InspectionProfileEntry)this, "CHECK_NON_ANNOTATED_REFERENCES");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){
            final Pair<String, ? extends Set<String>> annotationName;
            {
                this.annotationName = Configuration.getProjectInstance(holder.getProject()).getAdvancedConfiguration().getLanguageAnnotationPair();
            }

            public void visitExpression(PsiExpression expression) {
                LanguageMismatch.this.checkExpression(expression, holder, this.annotationName);
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                if (expression.getParent() instanceof PsiMethodCallExpression) {
                    return;
                }
                PsiElement element = expression.resolve();
                if (!(element instanceof PsiModifierListOwner)) {
                    return;
                }
                LanguageMismatch.this.checkExpression((PsiExpression)expression, holder, this.annotationName);
            }
        };
    }

    void checkExpression(PsiExpression expression, ProblemsHolder holder, Pair<String, ? extends Set<String>> annotationName) {
        PsiModifierListOwner declOwner;
        String expected;
        PsiAnnotation[] annotations;
        PsiType type = expression.getType();
        if (type == null || !PsiUtilEx.isStringOrStringArray(type)) {
            return;
        }
        PsiModifierListOwner contextOwner = AnnotationUtilEx.getAnnotatedElementFor((PsiElement)expression, AnnotationUtilEx.LookupType.CONTEXT_ONLY);
        if (contextOwner != null && PsiUtilEx.isLanguageAnnotationTarget(contextOwner) && (annotations = AnnotationUtilEx.getAnnotationFrom(contextOwner, annotationName, true)).length > 0 && (expected = AnnotationUtilEx.calcAnnotationValue(annotations, "value")) != null && (declOwner = AnnotationUtilEx.getAnnotatedElementFor((PsiElement)expression, AnnotationUtilEx.LookupType.PREFER_DECLARATION)) != null && PsiUtilEx.isLanguageAnnotationTarget(declOwner)) {
            PsiAnnotation[] as = AnnotationUtilEx.getAnnotationFrom(declOwner, annotationName, true);
            if (as.length > 0) {
                String actual = AnnotationUtilEx.calcAnnotationValue(as, "value");
                if (!expected.equals(actual)) {
                    holder.registerProblem((PsiElement)expression, IntelliLangBundle.message("inspection.language.mismatch.description3", expected, actual), new LocalQuickFix[0]);
                }
            } else if (this.CHECK_NON_ANNOTATED_REFERENCES) {
                PsiAssignmentExpression a;
                PsiExpressionList list;
                PsiElement var = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiVariable.class, PsiExpressionList.class, PsiAssignmentExpression.class});
                if (var instanceof PsiVariable ? ((PsiVariable)var).getInitializer() != expression : (var instanceof PsiExpressionList ? !ArrayUtil.contains((Object)expression, (Object[])(list = (PsiExpressionList)var).getExpressions()) : var instanceof PsiAssignmentExpression && (a = (PsiAssignmentExpression)var).getRExpression() != expression)) {
                    return;
                }
                if (declOwner instanceof PsiField && CollectionUtils.isConstantEmptyArray((PsiField)((PsiField)declOwner))) {
                    return;
                }
                if (AnnotateFix.canApplyOn(declOwner)) {
                    PsiAnnotation annotation = annotations[annotations.length - 1];
                    final String initializer = annotation.getParameterList().getText();
                    AnnotateFix fix = new AnnotateFix(annotation.getQualifiedName(), initializer){

                        @NotNull
                        public String getName() {
                            return initializer == null ? super.getName() : super.getName() + initializer;
                        }
                    };
                    holder.registerProblem((PsiElement)expression, IntelliLangBundle.message("inspection.language.mismatch.description2", expected), new LocalQuickFix[]{fix});
                } else {
                    holder.registerProblem((PsiElement)expression, IntelliLangBundle.message("inspection.language.mismatch.description", expected), new LocalQuickFix[0]);
                }
            }
        }
    }
}

