/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InjectedLanguage {
    private static Map<String, Language> ourLanguageCache;
    private static int ourLanguageCount;
    @NotNull
    private final String myID;
    @NotNull
    private final String myPrefix;
    @NotNull
    private final String mySuffix;
    private final boolean myDynamic;

    private InjectedLanguage(@NotNull String id, @NotNull String prefix, @NotNull String suffix, boolean dynamic) {
        this.myID = id;
        this.myPrefix = prefix;
        this.mySuffix = suffix;
        this.myDynamic = dynamic;
    }

    @NotNull
    public String getID() {
        return this.myID;
    }

    @Nullable
    public Language getLanguage() {
        return InjectedLanguage.findLanguageById(this.myID);
    }

    @NotNull
    public String getPrefix() {
        return this.myPrefix;
    }

    @NotNull
    public String getSuffix() {
        return this.mySuffix;
    }

    public boolean isDynamic() {
        return this.myDynamic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Language findLanguageById(@Nullable String langID) {
        if (langID == null || langID.isEmpty()) {
            return null;
        }
        Class<InjectedLanguage> clazz = InjectedLanguage.class;
        synchronized (InjectedLanguage.class) {
            if (ourLanguageCache == null || ourLanguageCount != Language.getRegisteredLanguages().size()) {
                InjectedLanguage.initLanguageCache();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ourLanguageCache.get(langID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String @NotNull [] getAvailableLanguageIDs() {
        Class<InjectedLanguage> clazz = InjectedLanguage.class;
        synchronized (InjectedLanguage.class) {
            if (ourLanguageCache == null || ourLanguageCount != Language.getRegisteredLanguages().size()) {
                InjectedLanguage.initLanguageCache();
            }
            Set<String> keys = ourLanguageCache.keySet();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ArrayUtilRt.toStringArray(keys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Language @NotNull [] getAvailableLanguages() {
        Class<InjectedLanguage> clazz = InjectedLanguage.class;
        synchronized (InjectedLanguage.class) {
            if (ourLanguageCache == null || ourLanguageCount != Language.getRegisteredLanguages().size()) {
                InjectedLanguage.initLanguageCache();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return (Language[])((StreamEx)StreamEx.of(ourLanguageCache.values()).distinct()).toArray(Language[]::new);
        }
    }

    private static void initLanguageCache() {
        ArrayList registeredLanguages;
        ourLanguageCache = ContainerUtil.createWeakValueMap();
        do {
            registeredLanguages = new ArrayList(Language.getRegisteredLanguages());
            for (Language language : registeredLanguages) {
                if (!LanguageUtil.isInjectableLanguage((Language)language)) continue;
                String languageID = language.getID();
                ourLanguageCache.put(languageID, language);
                String lowerCase = languageID.toLowerCase(Locale.ROOT);
                if (lowerCase.equals(languageID)) continue;
                ourLanguageCache.put(lowerCase, language);
            }
        } while (Language.getRegisteredLanguages().size() != registeredLanguages.size());
        ourLanguageCount = registeredLanguages.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InjectedLanguage that = (InjectedLanguage)o;
        return this.myID.equals(that.myID);
    }

    public int hashCode() {
        return this.myID.hashCode();
    }

    @Nullable
    public static InjectedLanguage create(String id) {
        return InjectedLanguage.create(id, "", "", false);
    }

    @Nullable
    public static InjectedLanguage create(@Nullable String id, String prefix, String suffix, boolean isDynamic) {
        return id == null ? null : new InjectedLanguage(id, prefix == null ? "" : prefix, suffix == null ? "" : suffix, isDynamic);
    }
}

