/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.injection.Injectable;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FileContentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.InjectActionsUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.references.InjectedReferencesContributor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectLanguageAction
implements IntentionAction,
LowPriorityAction {
    public static final String LAST_INJECTED_LANGUAGE = "LAST_INJECTED_LANGUAGE";
    public static final Key<Processor<? super PsiLanguageInjectionHost>> FIX_KEY = Key.create((String)"inject fix key");
    private static final FixPresenter DEFAULT_FIX_PRESENTER = (editor, range, pointer, text, handler) -> {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        HintManager.getInstance().showQuestionHint(editor, text, range.getStartOffset(), range.getEndOffset(), new QuestionAction(){

            public boolean execute() {
                return handler.process((Object)pointer.getElement());
            }
        });
    };

    @NotNull
    public static List<Injectable> getAllInjectables() {
        Language[] languages = InjectedLanguage.getAvailableLanguages();
        ArrayList<Injectable> list = new ArrayList<Injectable>();
        for (Language language : languages) {
            list.add(Injectable.fromLanguage((Language)language));
        }
        list.addAll(Arrays.asList((ReferenceInjector[])ReferenceInjector.EXTENSION_POINT_NAME.getExtensions()));
        Collections.sort(list);
        return list;
    }

    @NotNull
    public String getText() {
        return IntelliLangBundle.message("intelliLang.inject.language.action.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiLanguageInjectionHost host = InjectLanguageAction.findInjectionHost(editor, file);
        if (host == null) {
            return false;
        }
        if (Boolean.FALSE.equals(host.getUserData(InjectActionsUtils.ENABLED_FOR_HOST))) {
            return false;
        }
        List injectedPsi = InjectedLanguageManager.getInstance((Project)project).getInjectedPsiFiles((PsiElement)host);
        if (injectedPsi == null || injectedPsi.isEmpty()) {
            return !InjectedReferencesContributor.isInjected(file.findReferenceAt(editor.getCaretModel().getOffset()));
        }
        return false;
    }

    @Nullable
    protected static PsiLanguageInjectionHost findInjectionHost(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor instanceof EditorWindow) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        FileViewProvider vp = file.getViewProvider();
        for (Language language : vp.getLanguages()) {
            PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)vp.findElementAt(offset, language), PsiLanguageInjectionHost.class, (boolean)false);
            if (host == null || !host.isValidHost()) continue;
            return host;
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        InjectLanguageAction.doChooseLanguageToInject(editor, (Processor<? super Injectable>)((Processor)injectable -> {
            InjectLanguageAction.invokeImpl(project, editor, file, injectable);
            return false;
        }));
    }

    public static void invokeImpl(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull Injectable injectable) {
        InjectLanguageAction.invokeImpl(project, editor, file, injectable, DEFAULT_FIX_PRESENTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeImpl(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull Injectable injectable, @NotNull FixPresenter fixPresenter) {
        PsiLanguageInjectionHost host = InjectLanguageAction.findInjectionHost(editor, file);
        if (host == null) {
            return;
        }
        if (InjectLanguageAction.defaultFunctionalityWorked(host, injectable.getId())) {
            return;
        }
        try {
            host.putUserData(FIX_KEY, null);
            Language language = injectable.toLanguage();
            for (LanguageInjectionSupport support : InjectorUtils.getActiveInjectionSupports()) {
                if (!support.isApplicableTo(host) || !support.addInjectionInPlace(language, host)) continue;
                return;
            }
            if (TemporaryPlacesRegistry.getInstance(project).getLanguageInjectionSupport().addInjectionInPlace(language, host)) {
                Processor fixer = (Processor)host.getUserData(FIX_KEY);
                String text = IntelliLangBundle.message("intelliLang.temporary.injected", StringUtil.escapeXmlEntities((String)language.getDisplayName()));
                if (fixer != null) {
                    SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)host);
                    String fixText = text + "<br>" + (fixer instanceof MyFixAction ? ((MyFixAction)fixer).getText() : IntelliLangBundle.message("intelliLang.suggest.insert.annotation", new Object[0])) + " " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
                    fixPresenter.showFix(editor, host.getTextRange(), (SmartPsiElementPointer<PsiLanguageInjectionHost>)pointer, fixText, (Processor<? super PsiLanguageInjectionHost>)((Processor)host1 -> {
                        List files = InjectedLanguageManager.getInstance((Project)project).getInjectedPsiFiles((PsiElement)host1);
                        if (files != null) {
                            for (Pair pair : files) {
                                PsiFile psiFile = (PsiFile)pair.first;
                                LanguageInjectionSupport languageInjectionSupport = (LanguageInjectionSupport)psiFile.getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT);
                                if (languageInjectionSupport == null) continue;
                                languageInjectionSupport.removeInjectionInPlace((PsiLanguageInjectionHost)host1);
                            }
                        } else {
                            LanguageInjectionSupport support = (LanguageInjectionSupport)host1.getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT);
                            if (support != null && support.removeInjection((PsiElement)host)) {
                                host1.getManager().dropPsiCaches();
                            }
                        }
                        return fixer.process(host1);
                    }));
                } else {
                    HintManager.getInstance().showInformationHint(editor, text);
                }
            }
        }
        finally {
            if (injectable.getLanguage() != null) {
                FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
            } else {
                PsiManager.getInstance((Project)project).dropPsiCaches();
            }
        }
    }

    private static boolean defaultFunctionalityWorked(PsiLanguageInjectionHost host, String id) {
        return Configuration.getProjectInstance(host.getProject()).setHostInjectionEnabled(host, Collections.singleton(id), true);
    }

    public static boolean doChooseLanguageToInject(Editor editor, Processor<? super Injectable> onChosen) {
        ColoredListCellRenderer<Injectable> renderer = new ColoredListCellRenderer<Injectable>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Injectable> list, Injectable language, int index, boolean selected, boolean hasFocus) {
                this.setIcon(language.getIcon());
                this.append(language.getDisplayName());
                String description = language.getAdditionalDescription();
                if (description != null) {
                    this.append(description, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }
        };
        List<Injectable> injectables = InjectLanguageAction.getAllInjectables();
        String lastInjectedId = PropertiesComponent.getInstance().getValue(LAST_INJECTED_LANGUAGE);
        Injectable lastInjected = lastInjectedId != null ? (Injectable)ContainerUtil.find(injectables, injectable -> lastInjectedId.equals(injectable.getId())) : null;
        Dimension minSize = new JLabel(PlainTextLanguage.INSTANCE.getDisplayName(), EmptyIcon.ICON_16, 2).getMinimumSize();
        minSize.height *= 4;
        IPopupChooserBuilder builder = JBPopupFactory.getInstance().createPopupChooserBuilder(injectables).setRenderer((ListCellRenderer)renderer).setItemChosenCallback(injectable -> {
            onChosen.process(injectable);
            PropertiesComponent.getInstance().setValue(LAST_INJECTED_LANGUAGE, injectable.getId());
        }).setMinSize(minSize).setNamerForFiltering(language -> language.getDisplayName());
        if (lastInjected != null) {
            builder = builder.setSelectedValue((Object)lastInjected, true);
        }
        builder.createPopup().showInBestPositionFor(editor);
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void addFixer(@NotNull PsiLanguageInjectionHost host, Processor<? super PsiLanguageInjectionHost> annotationFixer, @NlsContexts.PopupContent String text) {
        host.putUserData(FIX_KEY, InjectLanguageAction.withFixName(annotationFixer, text));
    }

    public static Processor<? super PsiLanguageInjectionHost> withFixName(Processor<? super PsiLanguageInjectionHost> fix, @NlsContexts.PopupContent String text) {
        return new MyFixAction(text, fix);
    }

    private static final class MyFixAction
    implements Processor<PsiLanguageInjectionHost> {
        private final @NlsContexts.PopupContent String myText;
        private final Processor<? super PsiLanguageInjectionHost> myFix;

        private MyFixAction(@NlsContexts.PopupContent String text, Processor<? super PsiLanguageInjectionHost> fix) {
            this.myText = text;
            this.myFix = fix;
        }

        @NlsContexts.PopupContent
        public String getText() {
            return this.myText;
        }

        public boolean process(PsiLanguageInjectionHost host) {
            return this.myFix.process((Object)host);
        }
    }

    public static interface FixPresenter {
        public void showFix(@NotNull Editor var1, @NotNull TextRange var2, @NotNull SmartPsiElementPointer<PsiLanguageInjectionHost> var3, @NotNull @Nls String var4, @NotNull Processor<? super PsiLanguageInjectionHost> var5);
    }
}

