/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.injection.general.Injection;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.FallbackInjectionPerformer;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;

final class DefaultLanguageInjectionPerformer
implements FallbackInjectionPerformer {
    DefaultLanguageInjectionPerformer() {
    }

    public boolean isPrimary() {
        return false;
    }

    public boolean performInjection(@NotNull MultiHostRegistrar registrar, @NotNull Injection injection, @NotNull PsiElement context) {
        if (!(context instanceof PsiLanguageInjectionHost) || !((PsiLanguageInjectionHost)context).isValidHost()) {
            return false;
        }
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)context;
        PsiFile containingFile = context.getContainingFile();
        InjectedLanguage injectedLanguage = InjectedLanguage.create(injection.getInjectedLanguageId(), injection.getPrefix(), injection.getSuffix(), false);
        String injectionSupportId = injection.getSupportId();
        LanguageInjectionSupport support = injectionSupportId != null ? InjectorUtils.findInjectionSupport(injectionSupportId) : null;
        Language language = injectedLanguage.getLanguage();
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)host);
        if (language == null || manipulator == null) {
            if (injection instanceof BaseInjection) {
                return InjectorUtils.registerInjectionSimple(host, (BaseInjection)injection, support, registrar);
            }
            return false;
        }
        List<Trinity> trinities = Collections.singletonList(Trinity.create((Object)host, (Object)injectedLanguage, (Object)manipulator.getRangeInElement((PsiElement)host)));
        InjectorUtils.registerInjection(language, trinities, containingFile, registrar);
        if (support != null) {
            InjectorUtils.registerSupport(support, false, context, language);
        }
        return true;
    }

    public void registerSupportIfNone(PsiElement context, Injection injection) {
        LanguageInjectionSupport support;
        if (LanguageInjectionSupport.INJECTOR_SUPPORT.get((UserDataHolder)context) != null) {
            return;
        }
        String injectionSupportId = injection.getSupportId();
        LanguageInjectionSupport languageInjectionSupport = support = injectionSupportId != null ? InjectorUtils.findInjectionSupport(injectionSupportId) : null;
        if (support == null) {
            return;
        }
        Language language = InjectorUtils.getLanguageByString(injection.getInjectedLanguageId());
        if (language == null) {
            return;
        }
        InjectorUtils.registerSupport(support, false, context, language);
    }
}

